/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.hawk;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.util.ArrayList;

public class ProcessesMonitor
implements ITimestampedRunnable {
    private final IAgent iAgent;
    private static ProcessesMonitor instance = null;
    private DataAccumulatorFactory dataAccumulatorFactory;
    private ArrayList<Object> methodObjectList = new ArrayList();
    private static final String comp = "Processes";

    public ProcessesMonitor(IAgent agent) {
        instance = this;
        this.iAgent = agent;
        this.dataAccumulatorFactory = agent.IAgent_getDataAccumulatorFactory();
    }

    public static ProcessesMonitor getInstance(IAgent agent) {
        if (instance == null) {
            instance = new ProcessesMonitor(agent);
        }
        return instance;
    }

    public void init() {
    }

    public void ITimestampedRunnable_execute(long arg0) {
        try {
            for (Object obj : this.methodObjectList) {
                this.getProcessesMetrics(obj);
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.iAgent, "ERROR_IN_HAWKMONITOR_PROCESSES", bomb);
        }
    }

    private void getProcessesMetrics(Object methodObj) {
        String jobName = null;
        int limit = 11;
        try {
            TibcoBWUtils.getLogger().debug("ProcessesMonitor.getProcessesMetrics()");
            Class<?> amiParameterList = Class.forName("COM.TIBCO.hawk.ami.AmiParameterList", false, ClassLoader.getSystemClassLoader());
            Object argument = TibcoBWUtils.invokeMethodOnObject(methodObj, "getArguments");
            Object result = TibcoBWUtils.invokeMethodOnObject(methodObj, "onInvoke", new Class[]{amiParameterList}, new Object[]{argument});
            if (result != null) {
                Integer size = (Integer)TibcoBWUtils.invokeMethodOnObject(result, "size");
                TibcoBWUtils.getLogger().debug("Processes Size: " + size);
                int i = 0;
                while (i < size) {
                    Object param = TibcoBWUtils.invokeMethodOnObject(result, "getParameter", new Class[]{Integer.TYPE}, new Object[]{new Integer(i)});
                    if (param != null) {
                        String name = (String)TibcoBWUtils.invokeMethodOnObject(param, "getName");
                        Object value = TibcoBWUtils.invokeMethodOnObject(param, "getValue");
                        if (i % limit == 1) {
                            jobName = value.toString();
                        }
                        if (i % limit != 0) {
                            if (value != null) {
                                TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": " + value.toString());
                                this.reportMetric("Processes|" + jobName, name, value.toString());
                            } else {
                                TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": NULL");
                                this.reportMetric("Processes|" + jobName, name, "0");
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.iAgent, "ERROR_IN_HAWKMONITOR_PROCESSES", bomb);
        }
    }

    private void reportMetric(String component, String name, String value) {
        try {
            this.dataAccumulatorFactory.safeGetStringEveryEventDataAccumulator("Tibco|Hawk Metrics|" + component + ":" + name).IStringEveryEventDataAccumulator_addString(TibcoBWUtils.formatToBeResourceSafe(value));
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.iAgent, "ERROR_IN_HAWKMONITOR_PROCESSES", bomb);
        }
    }

    public void registerMethodObject(Object methodObj) {
        this.methodObjectList.add(methodObj);
    }

    public void deRegisterMethodObject(Object methodObj) {
        this.methodObjectList.remove(methodObj);
    }
}

