/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.jobstatistics.tracer;

import com.wily.introscope.agent.trace.InvocationData;
import com.wily.soaextension.tibcobw.KConstants;
import com.wily.soaextension.tibcobw.TibcoWeakHashSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JobWatchCollector {
    private static JobWatchCollector instance;
    private TibcoWeakHashSet jobCollection = new TibcoWeakHashSet();
    private TibcoWeakHashSet jobPoolCollection = new TibcoWeakHashSet();

    public static JobWatchCollector getInstance() {
        if (instance == null) {
            instance = new JobWatchCollector();
        }
        return instance;
    }

    private JobWatchCollector() {
    }

    public void register(InvocationData data) {
        Object objJobCreator = data.getInvocationObject();
        String pathName = null;
        try {
            pathName = this.getName(data);
            this.jobCollection.add(objJobCreator, pathName);
        }
        catch (Exception exception) {}
    }

    private String getName(InvocationData data) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String processName = null;
        processName = (String)data.getInvocationParameterAsObject(1);
        Object objJobPool = data.getInvocationParameterAsObject(0);
        Method getPoolNameMethod = objJobPool.getClass().getMethod(KConstants.kM_JobPool_getName, new Class[0]);
        String poolname = (String)getPoolNameMethod.invoke(objJobPool, new Object[0]);
        return String.valueOf(poolname) + "|" + processName;
    }

    public TibcoWeakHashSet getJobCreators() {
        return this.jobCollection;
    }

    public void registerJobPool(Object invocationObject) {
        String pathName = null;
        try {
            pathName = this.getPoolName(invocationObject);
            this.jobPoolCollection.add(invocationObject, pathName);
        }
        catch (Exception exception) {}
    }

    private String getPoolName(Object jobPool) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method getPoolNameMethod = jobPool.getClass().getMethod(KConstants.kM_JobPool_getName, new Class[0]);
        String name = (String)getPoolNameMethod.invoke(jobPool, new Object[0]);
        return name;
    }

    public TibcoWeakHashSet getJobPools() {
        return this.jobPoolCollection;
    }
}

