/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.multithread.blame;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.soaextension.tibcobw.KConstants;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.multithread.blame.MultiBoundaryBlameStackFeature;
import com.wily.util.properties.AttributeListing;

public class CalledBackendErrorTracer
extends ASingleMetricTracerFactory
implements KConstants {
    public CalledBackendErrorTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected IDataAccumulator createDataAccumulator(String arg0) {
        return null;
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (TibcoBWUtils.isMBBSEnabled() && TibcoBWUtils.isTibcoEngineThread() && data.hasInvocationThrownException()) {
            String component = null;
            String correlationId = this.getComponentTracer().getCrossProcessDataCache().getCorrelationID();
            MultiBoundaryBlameStackFeature blameStackFeature = (MultiBoundaryBlameStackFeature)MultiBoundaryBlameStackFeature.instance.get();
            String frontend = blameStackFeature.getCollector().getFrontend(correlationId);
            if (frontend != null) {
                component = this.formatParameterizedResource(data);
                try {
                    StringBuilder sCalledBackend = new StringBuilder();
                    sCalledBackend.append(component);
                    sCalledBackend.append(":");
                    sCalledBackend.append("Errors Per Interval");
                    StringBuilder kCalledBackend = new StringBuilder("Backends|");
                    kCalledBackend.append((CharSequence)sCalledBackend);
                    StringBuilder sbCalledBackend = new StringBuilder();
                    sbCalledBackend.append(frontend);
                    sbCalledBackend.append("|Called Backends|");
                    sbCalledBackend.append((CharSequence)sCalledBackend);
                    StringBuilder sbFrontend = new StringBuilder();
                    sbFrontend.append(frontend);
                    sbFrontend.append(":");
                    sbFrontend.append("Errors Per Interval");
                    this.getDataAccumulatorFactory().safeGetBackendLongIntervalCounterDataAccumulator(sbCalledBackend.toString()).ILongIntervalCounterDataAccumulator_addSingleIncident();
                    this.getDataAccumulatorFactory().safeGetBackendLongIntervalCounterDataAccumulator(kCalledBackend.toString()).ILongIntervalCounterDataAccumulator_addSingleIncident();
                    this.getDataAccumulatorFactory().safeGetFrontendLongIntervalCounterDataAccumulator(sbFrontend.toString()).ILongIntervalCounterDataAccumulator_addSingleIncident();
                }
                catch (Exception e) {
                    TibcoBWUtils.getLogger().error("Could not propagate the errors metric from backends to frontend" + e.toString());
                }
            } else {
                TibcoBWUtils.getLogger().debug("CalledBackendErrorTracer:: Could not find the frontend for error propagation for backend" + component);
            }
        }
    }

    public void ITracer_startTrace(int arg0, InvocationData arg1) {
    }
}

