/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.multithread.blame;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.soaextension.tibcobw.KConstants;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.util.StringUtils;

public class FrontendNameFormatter
implements INameFormatter,
KConstants {
    private static final String kEMS_SERVER = "EMS-SERVER";
    private static final String kTIBCO_EMS_SERVER = "TIBCO EMS Server";
    private static final String kTIBCO_RV = "TIBCO Rendzvous";
    private static final String kJMS_SERVER = "JMS Server";
    private static final String kAtString = " at ";
    private static final String kUrlString = "URL=tcp://";
    private static final String kOnPortString = " on port ";
    private static final String kRegex = ".*:\\d*";
    private static final String[] JMSContextTypes = new String[]{"JMSEventContext", "AEEventSourceContext", "JMSGetMessageEventContext", "ReceiveNotificationJmsEventContext", "SoapJmsEventContext"};

    public FrontendNameFormatter(IAgent agent) {
    }

    public boolean isJMSType(String jmsType) {
        boolean flag = false;
        String[] stringArray = JMSContextTypes;
        int n = JMSContextTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (jmsType.contains(s)) {
                flag = true;
                break;
            }
            ++n2;
        }
        return flag;
    }

    public String getFrontendURL(InvocationData data) {
        Object invocationObject = data.getInvocationObject();
        String frontendURL = "UnknownURL";
        data.getInvocationParameterAsObject(1);
        try {
            Object processStarter = TibcoBWUtils.getField(invocationObject, KConstants.kF_ProcessStarter_Long);
            Object eventSource = TibcoBWUtils.getField(processStarter, "eventSource");
            Object processName = TibcoBWUtils.getField(processStarter, "processName");
            StringBuilder sb = new StringBuilder();
            sb.append(eventSource.getClass().getSimpleName());
            sb.append("(");
            sb.append(processName);
            sb.append(")");
            frontendURL = sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return frontendURL;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        if (name.indexOf("{frontendurl}", 0) >= 0) {
            name = StringUtils.replace((String)name, (String)"{frontendurl}", (String)this.getFrontendURL(data));
        }
        return name;
    }
}

