/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.processes.tracer.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.AAgentMetricArray;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedElement;
import com.wily.introscope.agent.trace.cas.SharedDataStructure2;
import com.wily.introscope.agent.trace.cas.SharedDataStructure3;
import com.wily.introscope.agent.trace.hc2.AverageMetricGathererWrapper;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.CountMetricGathererWrapper;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.soaextension.tibcobw.ATibcoSingleInstanceTracer;
import com.wily.soaextension.tibcobw.KConstants;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.TibcoPPException;
import com.wily.soaextension.tibcobw.TibcoReflectionCache;
import com.wily.soaextension.tibcobw.processes.tracer.JobThreadlocal;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Field;
import java.util.HashMap;

public class JobRemoveTracer
extends ATibcoSingleInstanceTracer {
    private static final String kErrorMsg = ":Process Killed";
    private static final String kpath_subprocstart = "Tibco|Processes|Subprocesses|";
    private static final String ksuprocess_startchar = ">";
    private static Field jobVariablesField = null;
    private static final String TracerName = "JobRemoveTracer: ";

    public JobRemoveTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int arg0, InvocationData arg1) {
    }

    public void ITracer_startTrace(int arg0, InvocationData data) {
        if (!JobThreadlocal.isEnd()) {
            JobThreadlocal.setEnd(true);
        } else {
            try {
                this.CallJobFinish(data);
            }
            catch (TibcoPPException tibcoPPException) {}
            JobThreadlocal.removeEndTh();
        }
    }

    private void CallJobFinish(InvocationData data) throws TibcoPPException {
        Object objJob = data.getInvocationParameterAsObject(0);
        String component = this.formatParameterizedName(data);
        HashMap variablesMap = null;
        try {
            variablesMap = this.getJobHashMap(objJob);
            if (variablesMap != null && variablesMap.containsKey("com.wily.soaextension.tibcobw.BPstarttimeKey")) {
                Object ObjfulltaskName;
                Object Track = TibcoReflectionCache.getM_getCurrentTrack(objJob);
                if (Track != null && (ObjfulltaskName = TibcoReflectionCache.getM_getFullTaskName(Track)) != null) {
                    String taskName = (String)ObjfulltaskName;
                    while (taskName.contains(ksuprocess_startchar)) {
                        String subcompname = kpath_subprocstart;
                        int startindex = taskName.lastIndexOf(62);
                        int lastindex = taskName.lastIndexOf(47);
                        String tempProcname = taskName.substring(startindex + 1, lastindex);
                        taskName = taskName.substring(0, startindex);
                        Object substarttime = variablesMap.get(subcompname = String.valueOf(subcompname) + tempProcname);
                        if (substarttime != null) {
                            // empty if block
                        }
                        this.processMetrics(subcompname, (String)substarttime, data);
                    }
                }
                String st = (String)variablesMap.get("com.wily.soaextension.tibcobw.BPstarttimeKey");
                this.processMetrics(component, st, data);
            }
        }
        catch (Exception e) {
            throw new TibcoPPException(TracerName, e.getMessage());
        }
    }

    private HashMap getJobHashMap(Object createdJobObject) throws TibcoPPException {
        HashMap variablesMap = null;
        try {
            if (jobVariablesField == null) {
                Class<?> clazz = createdJobObject.getClass();
                jobVariablesField = TibcoReflectionCache.getFieldReflection(KConstants.kF_Job_M, clazz, true);
            }
            variablesMap = (HashMap)jobVariablesField.get(createdJobObject);
        }
        catch (Exception e) {
            throw new TibcoPPException(TracerName, e.getMessage());
        }
        return variablesMap;
    }

    private void processMetrics(String component, String st, InvocationData data) {
        long startTime = Long.valueOf(st);
        long endTime = data.getWallClockFinishTime();
        long elapsedTime = endTime - startTime;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        AgentMetric responseTimeMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(String.valueOf(component) + ":Average Response Time (ms)", 1025, "Invalid Names:Invalid name given for an integer duration metric");
        AverageMetricGathererWrapper timerWrapper = AverageMetricGathererWrapper.getFactory((boolean)true);
        SharedDataStructure2 newResp = new SharedDataStructure2((ISharedElement)timerWrapper);
        AAgentMetricArray responseTimeAAgentMetricArray = AAgentMetricArray.getInstance((AgentMetric)responseTimeMetric);
        WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AAgentMetricArray)responseTimeAAgentMetricArray, (IRepository)newResp);
        AgentMetric responsePerIntervalMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(String.valueOf(component) + ":Responses Per Interval", 8194, "Invalid Names:Invalid name given for a long interval counter metric");
        CountMetricGathererWrapper wrapper1 = CountMetricGathererWrapper.getFactory((boolean)true);
        SharedDataStructure2 newPerInt = new SharedDataStructure2((ISharedElement)wrapper1);
        AAgentMetricArray responsePerIntervalAAgentMetricArray = AAgentMetricArray.getInstance((AgentMetric)responsePerIntervalMetric);
        WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AAgentMetricArray)responsePerIntervalAAgentMetricArray, (IRepository)newPerInt);
        AgentMetric concurrentInvocationMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(String.valueOf(component) + ":Concurrent Invocations", 257, "Invalid Names:Invalid name given for an integer fluctuating counter metric");
        CountMetricGathererWrapper wrapper = CountMetricGathererWrapper.getFactory((boolean)false);
        SharedDataStructure3 newConcurrentDS = new SharedDataStructure3((ISharedElement)wrapper);
        AAgentMetricArray concurrentInvocationAAgentMetricArray = AAgentMetricArray.getInstance((AgentMetric)concurrentInvocationMetric);
        WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AAgentMetricArray)concurrentInvocationAAgentMetricArray, (IRepository)newConcurrentDS);
        AgentMetric errorsPerIntervalMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(String.valueOf(component) + ":" + "Errors Per Interval", 8194, "Invalid Names:Invalid name given for a long interval counter metric");
        CountMetricGathererWrapper wrapper11 = CountMetricGathererWrapper.getFactory((boolean)true);
        SharedDataStructure2 newErr = new SharedDataStructure2((ISharedElement)wrapper11);
        AAgentMetricArray errorsPerIntervalAAgentMetricArray = AAgentMetricArray.getInstance((AgentMetric)errorsPerIntervalMetric);
        WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AAgentMetricArray)errorsPerIntervalAAgentMetricArray, (IRepository)newErr);
        WilyTransactionStructure.getGlobalGatherer((AAgentMetricArray)responseTimeAAgentMetricArray).update(BlamePointTracer.getUpdater(), elapsedTime, startTime, endTime);
        WilyTransactionStructure.getGlobalGatherer((AAgentMetricArray)responsePerIntervalAAgentMetricArray).update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
        WilyTransactionStructure.getGlobalGatherer((AAgentMetricArray)concurrentInvocationAAgentMetricArray).update(BlamePointTracer.getDecreaser(), 0L, startTime, endTime);
        String errorMessage = String.valueOf(component) + kErrorMsg;
        ErrorFeature.constructAndSendErrorSnapshotToServer((InvocationData)data, (String)errorMessage, (IAgent)this.getAgent());
        ErrorFeature.decorateTransactionsWithError((InvocationData)data, (String)errorMessage);
        if (isDebugEnabled) {
            TibcoBWUtils.getLogger().debug(TracerName + errorMessage);
        }
        WilyTransactionStructure.getGlobalGatherer((AAgentMetricArray)errorsPerIntervalAAgentMetricArray).update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
    }
}

