/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.ws;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.TibcoReflectionCache;
import com.wily.soaextension.tibcobw.nameformatter.BWGenericFormatterHC;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WebServicesClientFormatterHC
extends BWGenericFormatterHC {
    private static final String C_SoapJmsRequestor = "com.tibco.bw.soap.share.reqrep.SoapJmsRequestor";

    public WebServicesClientFormatterHC(IAgent agent) {
        super(agent);
    }

    public String getNamespace(InvocationData data) {
        String namespace = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object service;
            Object requestor;
            Object soapSendReceive = data.getInvocationObject();
            if (soapSendReceive != null && (requestor = TibcoReflectionCache.getF_SoapSendReceiveActivity_requestor(soapSendReceive)) != null && (service = TibcoReflectionCache.getF_SoapRequestor_ISoapServiceConfig(requestor)) != null) {
                namespace = (String)TibcoReflectionCache.getF_SoapCommonConfig_wsdlNamespace(service);
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesClientFormatter.getNamespace: " + namespace);
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_NAME", bomb);
        }
        return namespace == null || namespace.trim().length() == 0 || namespace.equals("UnknownNamespace") ? "UnknownNamespace" : namespace;
    }

    public String getWebServiceURI(InvocationData data) {
        String webServiceURI = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object requestor;
            Object soapSendReceive = data.getInvocationObject();
            if (soapSendReceive != null && (requestor = TibcoReflectionCache.getF_SoapSendReceiveActivity_requestor(soapSendReceive)) != null) {
                if (requestor.getClass().getName().equalsIgnoreCase(C_SoapJmsRequestor)) {
                    Map urlToServiceConfigListMap;
                    Object engineConfig = TibcoReflectionCache.getF_SoapRequestor_SoapEngineConfig(requestor);
                    if (engineConfig != null && (urlToServiceConfigListMap = (Map)TibcoReflectionCache.getF_SoapEngineConfig_urlToServiceConfigListMap(engineConfig)) != null) {
                        Set col = urlToServiceConfigListMap.keySet();
                        Iterator itr = col.iterator();
                        while (itr.hasNext()) {
                            webServiceURI = itr.next().toString();
                        }
                    }
                } else {
                    Object endpointConfig = TibcoReflectionCache.getF_SoapHttpRequestor_SoapEndpointConfig(requestor);
                    if (endpointConfig != null) {
                        webServiceURI = (String)TibcoReflectionCache.getF_SoapEndpointConfiguration_kString(endpointConfig);
                    }
                }
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesClientFormatter.getWebServiceURI: " + webServiceURI);
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_NAME", bomb);
        }
        return webServiceURI == null || webServiceURI.trim().length() == 0 || webServiceURI.equals("UnknownServiceName") ? "UnknownServiceName" : webServiceURI;
    }

    public IBlameComponent getKey(IModuleFeedbackChannel imodulefeedbackchannel, String name, InvocationData invocationdata) {
        String namespace = this.getNamespace(invocationdata);
        invocationdata.put("com.wily.soaextension.tibcobw.NamespaceKey", (Object)namespace);
        return ABlameComponent.getArrayInstance((Object[])new Object[]{name, namespace});
    }
}

