/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.inherit;

import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.PrintWriter;
import java.util.Iterator;

public class RuntimeModeledClass
implements IModeledClass {
    private final Class fRuntimeClass;
    private IModuleFeedbackChannel fFeedback;
    static /* synthetic */ Class class$0;

    public RuntimeModeledClass(Class cls, IModuleFeedbackChannel feedback) {
        this.fRuntimeClass = cls;
        this.fFeedback = feedback;
    }

    public Iterator getAllDeclaredMethods() {
        throw new UnsupportedOperationException();
    }

    public boolean inheritsDirectlyFromInterface(IClassName interfaceName) {
        Class<?>[] intfs = this.fRuntimeClass.getInterfaces();
        int i = 0;
        while (i < intfs.length) {
            Class<?> intf = intfs[i];
            if (intf.getName().equals(interfaceName.getReflectionFriendlyQualifiedNameString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Iterator getAllMethods() {
        throw new UnsupportedOperationException();
    }

    public IClassName getClassName() {
        try {
            return ClassName.getClassName((String)this.fRuntimeClass.getName());
        }
        catch (InvalidClassNameException e) {
            this.fFeedback.debug((Throwable)e);
            return null;
        }
    }

    public IClassName getSuperClassName() {
        if (!this.hasSuperClass()) {
            return null;
        }
        try {
            return ClassName.getClassName((String)this.fRuntimeClass.getSuperclass().getName());
        }
        catch (InvalidClassNameException e) {
            this.fFeedback.debug((Throwable)e);
            return null;
        }
    }

    public boolean hasSuperClass() {
        Class clazz = this.fRuntimeClass.getSuperclass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return !clazz.equals(clazz2.getName());
    }

    public boolean isInterface() {
        return this.fRuntimeClass.isInterface();
    }

    public boolean isValueType() {
        return false;
    }

    public boolean containsAnnotation(IClassName annotationName) {
        return false;
    }

    public boolean referencesClass(IClassName referencedName) {
        throw new UnsupportedOperationException();
    }

    public boolean isInstanceOf(IClassName interfaceName) {
        try {
            Class<?> interfaceClass = Class.forName(interfaceName.getReflectionFriendlyQualifiedNameString(), false, this.fRuntimeClass.getClassLoader());
            return interfaceClass.isAssignableFrom(this.fRuntimeClass);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public void debugDump(PrintWriter log) {
    }
}

