/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ctg.server;

import com.ibm.ctg.server.APM_GlobalStatsExit_Poller;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.util.feedback.ABufferedApplicationFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.version.IVersion;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;

public class APM_GlobalStatsExit_BMonitor {
    private static ABufferedApplicationFeedbackChannel sFeedback;
    private static IStringLocalizer sLocalizer;
    private static IVersion sVersion;
    private static String sPropertiesFilename;
    private static Properties smfProps;
    public PrintStream trace_stdout;
    public IAgent my_agent;
    public APM_GlobalStatsExit_Poller gStatsPoller;
    public Thread statsThread;
    public String statHostname_property;
    public int statPort_property;
    public int statSleep_property;
    public boolean statsEnabled;
    public String stats_filter;

    public APM_GlobalStatsExit_BMonitor(String[] args, ABufferedApplicationFeedbackChannel feedback, IStringLocalizer localizer, IVersion version) throws IOException {
        try {
            this.my_agent = AgentShim.getAgent();
            this.trace_stdout = this.getDefaultStdout();
            this.gStatsPoller = null;
            this.stats_filter = null;
            sFeedback = new ABufferedApplicationFeedbackChannel("PPCTG: GlobalStats");
            this.statHostname_property = this.my_agent.IAgent_getIndexedProperties().getProperty("ppctg.statistics.host");
            this.trace_println("APM_RequestExit_Monitor PP CTG Global Statistics Hostname property=" + this.statHostname_property);
            if (this.statHostname_property == null) {
                this.statHostname_property = "localhost";
            }
            this.statPort_property = this.my_agent.IAgent_getIndexedProperties().safeGetIntProperty("ppctg.statistics.port", 2980, this.my_agent.IAgent_getModuleFeedback(), this.my_agent.IAgent_getStringLocalizer());
            if (this.statPort_property != 0) {
                this.trace_println("APM_RequestExit_Monitor PP CTG Global Statistics TCP Port property=" + this.statPort_property);
            } else {
                sFeedback.warn("CTG Global Stats Service statistics port was not defined. Will use default port=2980");
                this.trace_println("APM_RequestExit_Monitor PP CTG Global Statistics Port property NOT defined. Will use default port=2980");
                this.statPort_property = 2980;
            }
            this.statSleep_property = this.my_agent.IAgent_getIndexedProperties().safeGetIntProperty("ppctg.statistics.sleep", 60, this.my_agent.IAgent_getModuleFeedback(), this.my_agent.IAgent_getStringLocalizer());
            if (this.statSleep_property != 0) {
                this.trace_println("APM_RequestExit_Monitor PP CTG Global Statistics Sleep property=" + this.statSleep_property);
            } else {
                sFeedback.warn("CTG Global Stats Service statistics sleep time was not defined. Will use default sleep = 60 secoonds");
                this.trace_println("APM_RequestExit_Monitor PP CTG Global Statistics Sleep property NOT defined. Will use default sleep = 60 seconds");
                this.statSleep_property = 60;
            }
            try {
                this.gStatsPoller = new APM_GlobalStatsExit_Poller(this.my_agent, this.trace_stdout, sFeedback, this.stats_filter, this.statHostname_property, this.statPort_property, this.statSleep_property);
                this.trace_println("  ---****  APM_RequestExit_Monitor initialized Global Stats Poller service  ****---");
            }
            catch (Exception e) {
                this.trace_println("PP CTG Global Stats Service statistics are not available." + e.toString());
                sFeedback.warn("PP CTG Global Stats Service statistics are not available.", (Throwable)e);
                return;
            }
            if (this.gStatsPoller != null) {
                sFeedback.info("APM_RequestExit_Monitor PP CTG Global Stats Service successfully loaded.");
                this.statsThread = new Thread(this.gStatsPoller);
                this.statsThread.start();
                this.trace_println("  ---****  APM_RequestExit_Monitor started Global Stats Poller service Run Thread ****---");
            }
        }
        catch (Exception e) {
            System.out.println("Introscope startup logic failed: " + e.toString());
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        switch (args.length) {
            case 2: {
                try {
                    String cfr_ignored_0 = args[0];
                }
                catch (Exception exception) {
                    System.out.println("Error: invalid host specified\n");
                }
                try {
                    Integer.parseInt(args[1]);
                }
                catch (Exception exception) {
                    System.out.println("Error: invalid port specified defaulting to 2980\n");
                }
                break;
            }
            case 1: {
                try {
                    Integer.parseInt(args[0]);
                }
                catch (Exception exception) {
                    System.out.println("Error: invalid port specified defaulting to 2980\n");
                }
                break;
            }
        }
        try {
            new APM_GlobalStatsExit_BMonitor(args, sFeedback, sLocalizer, sVersion);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    public PrintStream getDefaultStdout() {
        return System.out;
    }

    public synchronized void trace_println(String msg_string) {
        System.out.println(msg_string);
    }
}

