/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.extension;

import [Ljava.net.URL;;
import com.wily.util.adt.AttributesStringDictionaryReader;
import com.wily.util.adt.IStringDictionaryReader;
import com.wily.util.extension.AExtension;
import com.wily.util.extension.ExtensionStringLocalizer;
import com.wily.util.extension.IPlugin;
import com.wily.util.extension.InvalidExtensionException;
import com.wily.util.extension.JarURLPhysicalModule;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.ExtendedFile;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.text.MultipleResourceBundleStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.jar.Attributes;

public class JarExtension
extends AExtension {
    private static final String kAspectJarDefaultName = "aspect" + File.separatorChar + "WilyPerstAspects.jar";
    private static final Class[] kClassLoaderParameterTypes = new Class[]{URL;.class, ClassLoader.class};
    private final IModuleFeedbackChannel fFeedback;
    private final ExtendedFile fTargetFile;
    private final JarURLPhysicalModule fJarModule;
    private final Attributes fMainAttributes;
    private final IStringDictionaryReader fAttributesReader;
    private ClassLoader fClassLoader;
    private final String fName;
    private String fClassloaderKey;
    private final String fType;
    private final List fDependencies;
    private final int fVersion;
    private MultipleResourceBundleStringLocalizer fExtensionLocalizer;
    private final List fPluginList;
    private int fSortRank;

    public JarExtension(String name, String[] dependencies, IModuleFeedbackChannel feedback, ExtendedFile target) throws InvalidExtensionException {
        Assertion.wilyAssert(target != null);
        this.fFeedback = feedback;
        this.fTargetFile = target;
        this.fName = name;
        this.fDependencies = Arrays.asList(dependencies);
        try {
            this.fJarModule = new JarURLPhysicalModule(this.fTargetFile.toURL());
        }
        catch (IOException e) {
            throw new InvalidExtensionException(new FormattedLocalizableMessage("Extension_Invalid_Jar_File_Message", new String[]{this.fTargetFile.getAbsolutePath()}));
        }
        this.fMainAttributes = this.fJarModule.getManifest().getMainAttributes();
        super.initialize(this.fTargetFile.getAbsolutePath(), this.fMainAttributes);
        this.fAttributesReader = new AttributesStringDictionaryReader(this.fMainAttributes);
        this.fType = this.getMainAttributeValueOrThrow("com-wily-Extension-Type");
        this.fVersion = this.getValidatedVersion();
        this.fClassloaderKey = this.getMainAttributeValue("com-wily-Extension-Classloader-Key");
        if (this.fClassloaderKey == null) {
            this.fClassloaderKey = "";
        }
        this.fPluginList = this.buildPluginList(this, this.getMainAttributeValueOrThrow("com-wily-Extension-Plugins-List"));
        this.getFeedback().debug("candidate jar file " + this.fTargetFile.getAbsolutePath() + " is an extension");
    }

    private ClassLoader createWeavingClassLoader(ClassLoader parent) throws InvalidExtensionException {
        URL[] classpath;
        String aspectJarLoc = (String)this.fMainAttributes.get("com-wily-Extension-AspectJar");
        File aspectJar = null;
        if (!(aspectJarLoc == null || aspectJarLoc.equals("") || aspectJarLoc.equals("default") || (aspectJar = new File(this.fTargetFile.getParentFile(), aspectJarLoc)).exists())) {
            aspectJar = null;
        }
        if (aspectJar == null) {
            aspectJar = new File(this.fTargetFile.getParentFile(), kAspectJarDefaultName);
        }
        try {
            classpath = new URL[]{aspectJar.toURL(), this.fTargetFile.toURL()};
        }
        catch (IOException e) {
            throw new InvalidExtensionException(new FormattedLocalizableMessage("Extension_Invalid_Jar_File_Message", new String[]{this.fTargetFile.getAbsolutePath()}));
        }
        try {
            Class<?> clsLoader = Class.forName("com.wily.persistence.perst.DelegatingNamedClassLoader");
            Constructor<?> constructor = clsLoader.getConstructor(String.class, URL;.class, ClassLoader.class);
            return (ClassLoader)constructor.newInstance(this.fName, classpath, parent);
        }
        catch (Exception e) {
            this.fFeedback.error("Failed creating weaving classloader!", e);
            throw new InvalidExtensionException(new FormattedLocalizableMessage("Extension_Invalid_Jar_File_Message", new String[]{this.fTargetFile.getAbsolutePath()}));
        }
    }

    private ClassLoader createClassLoader(URL[] classpath, ClassLoader parent) {
        ClassLoader result = this.createCustomClassLoader(classpath, parent);
        if (result == null) {
            result = new AllPermissionsClassLoader(classpath, parent);
        }
        return result;
    }

    private ClassLoader createCustomClassLoader(URL[] classpath, ClassLoader parent) {
        ClassLoader loader = null;
        String loaderPath = System.getProperty("com.wily.extension.classloader", this.getMainAttributeValue("com-wily-Extension-ClassLoader"));
        if (loaderPath != null) {
            try {
                Class<?> loaderClass = Class.forName(loaderPath, true, parent);
                Constructor<?> constructor = loaderClass.getConstructor(kClassLoaderParameterTypes);
                Object[] arguments = new Object[]{classpath, parent};
                loader = (ClassLoader)constructor.newInstance(arguments);
                this.getFeedback().info("Created loader");
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getTargetException();
                this.getFeedback().verbose(t);
            }
            catch (Throwable t) {
                this.getFeedback().verbose(t);
            }
        }
        return loader;
    }

    public void IExtension_setParentClassLoader(ClassLoader parentClassLoader) throws InvalidExtensionException {
        if (this.fMainAttributes.containsKey(new Attributes.Name("com-wily-Extension-AspectJar"))) {
            this.fClassLoader = this.createWeavingClassLoader(parentClassLoader);
        } else {
            URL[] classpathArray = null;
            try {
                classpathArray = this.getRecursiveUniqueClassPath(this.fJarModule.getURL());
            }
            catch (IOException e) {
                throw new InvalidExtensionException(new FormattedLocalizableMessage("Extension_Invalid_Jar_File_Message", new String[]{this.fTargetFile.getAbsolutePath()}));
            }
            this.fClassLoader = this.createClassLoader(classpathArray, parentClassLoader);
        }
        this.fExtensionLocalizer = this.buildStringLocalizer(this.fFeedback, this.fClassLoader, this.getMainAttributeValue("com-wily-Extension-Localized-Resource-List"));
    }

    public ClassLoader IExtension_getClassLoader() {
        return this.getExtensionClassLoader();
    }

    public IPlugin[] IExtension_getFilteredPluginList(String pluginFilter) {
        return this.getFilteredPluginList(this.fPluginList, pluginFilter);
    }

    public String IExtension_getName() {
        return this.fName;
    }

    public String IExtension_getClassloaderKey() {
        return this.fClassloaderKey;
    }

    public int IExtension_getVersion() {
        return this.fVersion;
    }

    public String IExtension_getSource() {
        return this.fTargetFile.safeGetCanonicalPath();
    }

    public IStringLocalizer IExtension_getStringLocalizer(IStringLocalizer fallback) {
        return new ExtensionStringLocalizer(this.fExtensionLocalizer, fallback);
    }

    public String IExtension_getType() {
        return this.fType;
    }

    public String[] IExtension_getDependencies() {
        return this.fDependencies.toArray(new String[0]);
    }

    public IStringDictionaryReader IExtension_getAttributes() {
        return this.fAttributesReader;
    }

    private IModuleFeedbackChannel getFeedback() {
        return this.fFeedback;
    }

    Map getMainAttributes() {
        return this.fMainAttributes;
    }

    private ClassLoader getExtensionClassLoader() {
        Assertion.wilyAssert(this.fClassLoader != null);
        return this.fClassLoader;
    }

    private final URL[] getRecursiveUniqueClassPath(URL selfURL) throws IOException, MalformedURLException {
        ArrayList<URL> deepResultList = new ArrayList<URL>();
        Stack<URL> stack = new Stack<URL>();
        stack.push(selfURL);
        while (!stack.empty()) {
            URL jarFile = (URL)stack.pop();
            if (deepResultList.contains(jarFile)) continue;
            deepResultList.add(jarFile);
            URL[] cp = new JarURLPhysicalModule(jarFile).getClassPath();
            for (int y = 0; y < cp.length; ++y) {
                if (deepResultList.contains(cp[y])) continue;
                stack.push(cp[y]);
            }
        }
        return deepResultList.toArray(new URL[deepResultList.size()]);
    }

    public String ITopologicalSortNode_getId() {
        return this.IExtension_getName();
    }

    public String[] ITopologicalSort_getDependencies() {
        return this.IExtension_getDependencies();
    }

    public int ITopologicalSort_getRank() {
        return this.fSortRank;
    }

    public void ITopologicalSort_setRank(int v) {
        this.fSortRank = v;
    }

    private static final class AllPermissionsClassLoader
    extends URLClassLoader {
        private static final Permissions permissions = new Permissions();

        private AllPermissionsClassLoader(URL[] classpath, ClassLoader parent) {
            super(classpath, parent);
        }

        protected PermissionCollection getPermissions(CodeSource codesource) {
            return permissions;
        }

        static {
            permissions.add(new AllPermission());
        }
    }
}

