/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.finder;

import com.wily.util.finder.IResourceFinder;
import com.wily.util.finder.IResourceFinderFeedback;
import com.wily.util.io.ExtendedFile;
import com.wily.util.resource.FileBasedResource;
import com.wily.util.resource.IResource;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.IOException;
import java.io.InputStream;

public class WilyDirectoryResourceFinder
implements IResourceFinder {
    private final String fDirectoryName;
    private final String fFileName;
    private final String fResourceToFindNameKey;

    public WilyDirectoryResourceFinder(String baseDirectoryName, String fileName, String resourceToFindNameKey) {
        Assertion.wilyAssert(resourceToFindNameKey != null);
        Assertion.wilyAssert(fileName != null);
        this.fDirectoryName = baseDirectoryName;
        this.fFileName = fileName;
        this.fResourceToFindNameKey = resourceToFindNameKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IResource IResourceFinder_findResource(IResourceFinderFeedback feedback) {
        FileBasedResource resultResource = null;
        String statusMessage = "";
        InputStream testStream = null;
        ExtendedFile wilyDirectory = new ExtendedFile(this.fDirectoryName);
        String fullPath = new ExtendedFile(wilyDirectory, this.fFileName).safeGetCanonicalPath();
        IStringLocalizer localizer = feedback.IResourceFinderFeedback_getStringLocalizer();
        statusMessage = localizer.IStringLocalizer_getFormattedLocalizedString("Resource_Finder_Working_Directory_Attempt_Message", this.fResourceToFindNameKey, true, fullPath, false);
        feedback.IResourceFinderFeedback_feedbackStatus(statusMessage);
        resultResource = new FileBasedResource(fullPath);
        testStream = resultResource.IResource_getContents();
        statusMessage = localizer.IStringLocalizer_getFormattedLocalizedString("Resource_Finder_Succeeded_Message", this.fFileName, fullPath);
        feedback.IResourceFinderFeedback_feedbackSuccess(statusMessage);
        Object var10_8 = null;
        if (testStream == null) return resultResource;
        try {
            testStream.close();
            return resultResource;
        }
        catch (IOException ioe) {}
        return resultResource;
        {
            catch (Throwable t) {
                statusMessage = localizer.IStringLocalizer_getFormattedLocalizedString("Resource_Finder_Failed_Message", this.fResourceToFindNameKey, true, t.getClass().getName(), false, t.getMessage(), false);
                feedback.IResourceFinderFeedback_feedbackFailure(statusMessage);
                resultResource = null;
                Object var10_9 = null;
                if (testStream == null) return resultResource;
                try {
                    testStream.close();
                    return resultResource;
                }
                catch (IOException ioe) {}
                return resultResource;
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (testStream == null) throw throwable;
            try {
                testStream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

