/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties;

import com.wily.util.IComparer;
import com.wily.util.Sorter;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;

public class IndexedProperties
extends Properties {
    private static final long serialVersionUID = -4663651679944106520L;
    private static final String kCanonicalBooleanTrueValue = "true";
    private static final String kCanonicalBooleanFalseValue = "false";
    private static final String kCanonicalBooleanMaybeValue = "maybe";
    private static final Random sRandomSource = new Random();

    public IndexedProperties() {
    }

    public IndexedProperties(Properties defaultProperties) {
        super(defaultProperties);
    }

    public IndexedProperties(Map initialValues) {
        Iterator entries = initialValues.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry current = entries.next();
            this.setProperty((String)current.getKey(), (String)current.getValue());
        }
    }

    public static IndexedProperties newInstance(IndexedProperties properties) {
        IndexedProperties copy = new IndexedProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propertyKey = (String)enumeration.nextElement();
            String propertyValue = properties.getProperty(propertyKey);
            copy.setProperty(propertyKey, propertyValue);
        }
        return copy;
    }

    public String getIndexedProperty(String key, int index) {
        return this.getProperty(key + "." + index);
    }

    public String getTrimmedIndexedProperty(String key, int index) {
        return this.getTrimmedProperty(key + "." + index);
    }

    public void putIndexedProperty(String key, int index, String property) {
        this.put(key + "." + index, property);
    }

    public String[] getIndexedProperties(String key) {
        return this.getIndexedProperties(key, false);
    }

    public String[] getTrimmedIndexedProperties(String key) {
        return this.getIndexedProperties(key, true);
    }

    private synchronized String[] getIndexedProperties(String key, boolean trimmed) {
        Vector<String> v = new Vector<String>();
        int i = 0;
        boolean done = false;
        while (!done) {
            String prop;
            String string = prop = trimmed ? this.getTrimmedIndexedProperty(key, i) : this.getIndexedProperty(key, i);
            if (prop != null) {
                v.addElement(prop);
            } else {
                done = true;
            }
            ++i;
        }
        Object[] props = new String[v.size()];
        v.copyInto(props);
        return props;
    }

    public String[] getAndCondenseAllIndexedProperties(String key) {
        return this.getAndCondenseAllIndexedProperties(key, false);
    }

    public String[] getAndCondenseAllTrimmedIndexedProperties(String key) {
        return this.getAndCondenseAllIndexedProperties(key, true);
    }

    private synchronized String[] getAndCondenseAllIndexedProperties(String key, boolean trimmed) {
        Vector<KeyIndex> v = new Vector<KeyIndex>();
        Enumeration<?> keys = this.propertyNames();
        while (keys.hasMoreElements()) {
            String nextKey = (String)keys.nextElement();
            int lastDotIndex = nextKey.lastIndexOf(".");
            if (lastDotIndex == -1 || !nextKey.substring(0, lastDotIndex).equals(key)) continue;
            try {
                int index = Integer.parseInt(nextKey.trim().substring(lastDotIndex + 1));
                v.addElement(new KeyIndex(index, nextKey));
            }
            catch (NumberFormatException e) {}
        }
        Object[] keyIndexArray = new KeyIndex[v.size()];
        v.copyInto(keyIndexArray);
        Sorter.sort(keyIndexArray, (IComparer)new KeyIndexComparer());
        String[] props = new String[keyIndexArray.length];
        for (int i = 0; i < props.length; ++i) {
            props[i] = trimmed ? this.getTrimmedProperty(((KeyIndex)keyIndexArray[i]).fKey) : this.getProperty(((KeyIndex)keyIndexArray[i]).fKey);
        }
        return props;
    }

    public synchronized void putIndexedProperties(String key, String[] values) {
        this.removeIndexedProperties(key);
        for (int i = 0; i < values.length; ++i) {
            this.putIndexedProperty(key, i, values[i]);
        }
    }

    public void addIndexedProperty(String key, String value) {
        String[] props = this.getIndexedProperties(key);
        this.putIndexedProperty(key, props.length, value);
    }

    public synchronized void removeIndexedProperties(String key) {
        int i = 0;
        boolean done = false;
        while (!done) {
            String prop = this.getIndexedProperty(key, i);
            if (prop != null) {
                this.remove(key + "." + i);
            } else {
                done = true;
            }
            ++i;
        }
    }

    public int getIntProperty(String key) {
        return this.getIntProperty(key, 0);
    }

    public int getIntProperty(String key, int defaultValue) {
        String p = this.getTrimmedProperty(key);
        if (p == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(p);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public int safeGetIntProperty(String key, int defaultValue, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        String p = this.getTrimmedProperty(key);
        if (p == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(p);
        }
        catch (NumberFormatException nfe) {
            feedback.warn(localizer.IStringLocalizer_getFormattedLocalizedString("Indexed_Properties_Integer_Wasnt_Key", key, p, "" + defaultValue));
            return defaultValue;
        }
    }

    public int safeGetNonNegativeIntProperty(String key, int defaultValue, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        Assertion.wilyAssert(defaultValue >= 0);
        int result = this.safeGetIntProperty(key, defaultValue, feedback, localizer);
        if (result < 0) {
            feedback.warn(localizer.IStringLocalizer_getFormattedLocalizedString("Indexed_Properties_Non_Negative_Integer_Wasnt_Key", key, "" + result, "" + defaultValue));
            result = defaultValue;
        }
        return result;
    }

    public int safeGetPositiveIntProperty(String key, int defaultValue, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        Assertion.wilyAssert(defaultValue >= 0);
        int result = this.safeGetIntProperty(key, defaultValue, feedback, localizer);
        if (result <= 0) {
            feedback.warn(localizer.IStringLocalizer_getFormattedLocalizedString("Indexed_Properties_Positive_Integer_Wasnt_Key", key, "" + result, "" + defaultValue));
            result = defaultValue;
        }
        return result;
    }

    public String[] safeGetSeparatedProperty(String key, String separator) {
        if (key == null || separator == null) {
            return null;
        }
        String p = this.getProperty(key);
        if (p == null) {
            return null;
        }
        p = p.trim();
        return StringUtils.parseList(p, separator);
    }

    public String[] safeGetSeparatedProperty(String key, String separator, String[] defaultValue) {
        String[] retVal = this.safeGetSeparatedProperty(key, separator);
        return retVal == null ? defaultValue : retVal;
    }

    public int getIndexedIntProperty(String key, int index) {
        return this.getIntProperty(key + "." + index);
    }

    public long getLongProperty(String key) {
        String p = this.getTrimmedProperty(key);
        if (p == null) {
            return 0L;
        }
        return Long.parseLong(p);
    }

    public long getLongProperty(String key, long defaultValue) {
        String p = this.getTrimmedProperty(key);
        if (p == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(p);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean safeGetBooleanProperty(String key, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        return this.safeGetBooleanProperty(key, false, feedback, localizer);
    }

    public boolean safeGetBooleanProperty(String key, boolean defaultValue, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        String value = this.getTrimmedProperty(key);
        if (value == null) {
            return defaultValue;
        }
        boolean result = value.equalsIgnoreCase(kCanonicalBooleanTrueValue);
        if (value.equalsIgnoreCase(kCanonicalBooleanMaybeValue)) {
            return sRandomSource.nextBoolean();
        }
        if (!result && !value.equalsIgnoreCase(kCanonicalBooleanFalseValue)) {
            feedback.warn(localizer.IStringLocalizer_getFormattedLocalizedString("Indexed_Properties_Boolean_Wasnt_Key", key, value, "" + defaultValue));
            result = defaultValue;
        }
        return result;
    }

    public boolean getBooleanProperty(String key) {
        String b = this.getTrimmedProperty(key);
        if (b == null) {
            return false;
        }
        if (b.equalsIgnoreCase(kCanonicalBooleanMaybeValue)) {
            return sRandomSource.nextBoolean();
        }
        return b.equalsIgnoreCase(kCanonicalBooleanTrueValue);
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String b = this.getTrimmedProperty(key);
        if (b == null) {
            return defaultValue;
        }
        if (b.equalsIgnoreCase(kCanonicalBooleanMaybeValue)) {
            return sRandomSource.nextBoolean();
        }
        return b.equalsIgnoreCase(kCanonicalBooleanTrueValue);
    }

    public void setBooleanProperty(String key, boolean value) {
        this.put(key, new Boolean(value).toString());
    }

    public void load(AttributeListing listing) {
        Iterator iterator = listing.getKeys();
        while (iterator.hasNext()) {
            String attribute = (String)iterator.next();
            String value = listing.get(attribute);
            this.put(attribute, value);
        }
    }

    public String getTrimmedProperty(String property) {
        String result = this.getProperty(property);
        return result == null ? null : result.trim();
    }

    public String getTrimmedProperty(String property, String defaultValue) {
        String result = this.getProperty(property);
        return result == null ? defaultValue : result.trim();
    }

    public String getNamedProperty(String prefix, String name) {
        prefix = prefix.endsWith(".") ? prefix : prefix + ".";
        String property = this.getProperty(prefix + name);
        return property;
    }

    public String getTrimmedNamedProperty(String prefix, String name) {
        String property = this.getNamedProperty(prefix, name);
        return property == null ? null : property.trim();
    }

    private class KeyIndexComparer
    implements IComparer {
        private KeyIndexComparer() {
        }

        public boolean lessThan(Object obj1, Object obj2) {
            return ((KeyIndex)obj1).fIndex < ((KeyIndex)obj2).fIndex;
        }

        public boolean equalTo(Object obj1, Object obj2) {
            return ((KeyIndex)obj1).fIndex == ((KeyIndex)obj2).fIndex;
        }
    }

    private class KeyIndex {
        public final int fIndex;
        public final String fKey;

        private KeyIndex(int index, String key) {
            this.fIndex = index;
            this.fKey = key;
        }
    }
}

