/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.extension;

import com.wily.util.io.ExtendedFile;
import com.wily.wilyassert.Assertion;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

final class JarURLPhysicalModule {
    private static final URL[] kZeroLengthURLArray = new URL[0];
    private final URL fTargetURL;
    private final String fParent;
    private final String fProtocol;
    private final Manifest fManifest;
    private final URL[] fClassPath;
    private final URL[] fClassPathIncludingSelf;

    JarURLPhysicalModule(URL url) throws IOException, MalformedURLException {
        this.fProtocol = url.getProtocol();
        this.fTargetURL = JarURLPhysicalModule.getJarURL(url);
        this.fParent = JarURLPhysicalModule.getParentURLString(this.fTargetURL.toString());
        this.fManifest = this.findManifest();
        this.fClassPath = this.computeClassPath();
        this.fClassPathIncludingSelf = this.computeClassPathWithSelf();
    }

    final URL[] getClassPath() {
        return this.fClassPath;
    }

    final URL[] getClassPathIncludingSelf() {
        return this.fClassPathIncludingSelf;
    }

    final URL getURL() {
        return this.fTargetURL;
    }

    public String toString() {
        return this.getURL().toString();
    }

    private Manifest findManifest() throws IOException {
        JarURLConnection conn = (JarURLConnection)this.fTargetURL.openConnection();
        conn.connect();
        Manifest manifest = conn.getManifest();
        if (manifest == null && (manifest = JarURLPhysicalModule.getManifestFromJarFile(conn.getJarFile())) == null) {
            throw new IOException("manifest not found");
        }
        Assertion.wilyAssert(manifest != null);
        return manifest;
    }

    public Manifest getManifest() {
        Assertion.wilyAssert(this.fManifest != null);
        return this.fManifest;
    }

    private URL[] computeClassPath() throws MalformedURLException {
        URL[] result;
        Manifest manifest = this.getManifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        String classPathString = mainAttributes.getValue("Class-Path");
        if (classPathString == null) {
            result = kZeroLengthURLArray;
        } else {
            Collection urlBag = JarURLPhysicalModule.getStringClassPathElementsAsURLCollection(JarURLPhysicalModule.getStringTokensAsArray(classPathString, " "), this.fParent, this.fProtocol);
            result = urlBag.toArray(kZeroLengthURLArray);
        }
        return result;
    }

    private URL[] computeClassPathWithSelf() {
        ArrayList<URL> completeList = new ArrayList<URL>();
        completeList.add(this.getURL());
        List<URL> deepList = Arrays.asList(this.getClassPath());
        completeList.addAll(deepList);
        return completeList.toArray(kZeroLengthURLArray);
    }

    private static final Collection getStringClassPathElementsAsURLCollection(String[] paths, String parent, String protocol) throws MalformedURLException {
        ArrayList<URL> list = new ArrayList<URL>();
        int y = paths.length;
        for (int x = 0; x < y; ++x) {
            String path = paths[x];
            URL url = null;
            try {
                url = new URL(JarURLPhysicalModule.getJarURLString(path));
            }
            catch (MalformedURLException mue) {
                url = ExtendedFile.isAbsolutePath(path) ? new URL(JarURLPhysicalModule.getJarURLString(protocol + ":/" + path)) : new URL(JarURLPhysicalModule.getJarURLString(parent + "/" + path));
            }
            list.add(url);
        }
        return list;
    }

    private static final Manifest getManifestFromJarFile(JarFile jar) throws IOException {
        Enumeration<JarEntry> e = jar.entries();
        JarEntry entry = null;
        while (e.hasMoreElements()) {
            entry = e.nextElement();
            if (!entry.getName().equalsIgnoreCase("META-INF/MANIFEST.MF")) continue;
            return new Manifest(jar.getInputStream(entry));
        }
        return null;
    }

    public static final String getParentURLString(String url) {
        url = url.substring(0, url.lastIndexOf("!"));
        url = url.substring(0, url.lastIndexOf("/"));
        return url;
    }

    public static final URL getJarURL(URL url) throws MalformedURLException {
        return new URL(JarURLPhysicalModule.getJarURLString(url.toString()));
    }

    public static final String getJarURLString(String urlString) {
        if (!urlString.startsWith("jar:")) {
            urlString = "jar:" + urlString;
        }
        if (urlString.indexOf(33) == -1) {
            urlString = urlString + "!/";
        }
        return urlString;
    }

    private static final String[] getStringTokensAsArray(String list, String token) {
        StringTokenizer strTok = new StringTokenizer(list, token);
        String[] array = new String[strTok.countTokens()];
        for (int x = 0; x < array.length; ++x) {
            array[x] = strTok.nextToken().trim();
        }
        return array;
    }
}

