/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties;

import com.wily.util.event.EventPump;
import com.wily.util.event.ITrackableListener;
import com.wily.util.event.ListenerTracker;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.IPropertiesHandler;
import com.wily.util.properties.IPropertyEventListener;
import com.wily.util.properties.PropertyEvent;
import java.util.Enumeration;

public class PropertyChangeNotifier {
    private final EventPump fEventPump;
    private final ListenerTracker fListeners;
    private final IPropertiesHandler fHandler;

    public PropertyChangeNotifier(IModuleFeedbackChannel feedback, EventPump eventPump, IPropertiesHandler handler) {
        this.fEventPump = eventPump;
        this.fListeners = new ListenerTracker(feedback, "notifying properties", IPropertyEventListener.class);
        this.fHandler = handler;
    }

    public synchronized void noticePropertyChange(Object key, Object oldValue, Object newValue) {
        this.notifyNewPropertyValue(ListenerTracker.kBroadcastToAllListeners, (String)key, (String)oldValue, (String)newValue, false);
    }

    public synchronized void noticeIndexedPropertyChange(Object key, Object oldValue, Object newValue) {
        this.notifyNewPropertyValue(ListenerTracker.kBroadcastToAllListeners, (String)key, (String)oldValue, (String)newValue, true);
    }

    public synchronized void addBroadcastListenerWithRewind(ITrackableListener listener) {
        this.propertiesRewind(listener);
        this.fEventPump.postAddBroadcastListener(this.fListeners, listener);
    }

    public synchronized void removeBroadcastListener(ITrackableListener listener) {
        this.fEventPump.postRemoveBroadcastListener(this.fListeners, listener);
    }

    private synchronized void postTargetedEvent(ITrackableListener listener, PropertyEvent event) {
        this.fEventPump.postTargetedEvent(this.fListeners, listener, event);
    }

    private void notifyNewPropertyValue(ITrackableListener listener, String key, String previousValue, String currentValue) {
        this.notifyNewPropertyValue(listener, key, previousValue, currentValue, false);
    }

    private void notifyNewPropertyValue(ITrackableListener listener, String key, String previousValue, String currentValue, boolean isIndexed) {
        PropertyEvent newValueEvent = new PropertyEvent(110001, key, previousValue, currentValue, isIndexed);
        this.postTargetedEvent(listener, newValueEvent);
    }

    private void propertiesRewind(ITrackableListener listener) {
        if (this.fHandler.IPropertiesHandler_supportsRewind()) {
            Enumeration keys = this.fHandler.IPropertiesHandler_getKeys();
            while (keys.hasMoreElements()) {
                String currentKey = (String)keys.nextElement();
                this.notifyNewPropertyValue(listener, currentKey, null, this.fHandler.IPropertiesHandler_getValue(currentKey));
            }
        }
    }
}

