/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.sqlagent.SQLAgentConfiguration;
import com.wily.introscope.agent.sqlagent.StatementNormalizer;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.ICacheableInvocationDataTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.adt.CanonicalObjectPool;
import com.wily.util.adt.IAgedMap;
import com.wily.util.adt.IConcurrentMapFactory;
import com.wily.util.adt.IGuaranteedCounter;
import com.wily.util.adt.IWeakIdentityMap;
import com.wily.util.adt.IWeakMap;
import com.wily.util.adt.WeakIdentityHashMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class StatementToSQLMappingTracer
extends ASingleInstanceTracerFactory
implements ICacheableInvocationDataTracerFactory {
    private static final int kMapCount = 32;
    private static final int kMapBitField = 31;
    private static final IWeakIdentityMap concStatementToSQL;
    private static final IWeakMap concRawToNorm;
    private static final IWeakIdentityMap concStatementToBlameKey;
    private static final WeakIdentityHashMap[] sStatementToSQLMaps;
    private static final ThreadLocal sStatementToSQLThreadLocal;
    private static final WeakHashMap[] sRawToNormalizedSQLMaps;
    private static final ThreadLocal sRawToNormalizedSQLThreadLocal;
    private static final Map sStatementTypeMap;
    private static SQLAgentConfiguration fConfiguration;
    private static final IGuaranteedCounter sNormalizerConfigCounter;
    public static final String kSQLParameterIndexKey = "sqlparameterindex";
    private final int sqlParameterIndex = this.getIntegerParameter("sqlparameterindex", 0);

    static {
        sStatementToSQLMaps = new WeakIdentityHashMap[32];
        sRawToNormalizedSQLMaps = new WeakHashMap[32];
        int i = 0;
        while (i < 32) {
            StatementToSQLMappingTracer.sStatementToSQLMaps[i] = new WeakIdentityHashMap();
            StatementToSQLMappingTracer.sRawToNormalizedSQLMaps[i] = new WeakHashMap();
            ++i;
        }
        sStatementTypeMap = new HashMap();
        sStatementTypeMap.put("createStatement", "Dynamic");
        sStatementTypeMap.put("prepareStatement", "Prepared");
        sStatementTypeMap.put("prepareCall", "Stored Procedures");
        sStatementTypeMap.put("allocateStatement", "Dynamic");
        sStatementTypeMap.put("allocatePreparedStatement", "Prepared");
        sStatementTypeMap.put("allocateCallableStatement", "Stored Procedures");
        sStatementToSQLThreadLocal = new ThreadLocal(){

            protected Object initialValue() {
                return new WeakIdentityHashMap();
            }
        };
        IConcurrentMapFactory factory = null;
        IGuaranteedCounter counter = null;
        try {
            factory = AgentShim.getAgent().IAgent_getConcurrentMapFactory();
            fConfiguration = SQLAgentConfiguration.getInstance(AgentShim.getAgent());
            counter = AgentShim.getAgent().IAgent_getGuaranteedCounter();
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            factory = new IConcurrentMapFactory(){

                public Map getConcurrentMap(String name) {
                    return new HashMap();
                }

                public IAgedMap getConcurrentAgingMap(String name) {
                    return null;
                }

                public IWeakMap getConcurrentWeakMap(String name) {
                    return null;
                }

                public IWeakIdentityMap getConcurrentWeakIdentityMap(String name) {
                    return null;
                }

                public void startConcurrentMapFactory(IModuleFeedbackChannel feedback, IntervalHeartbeat beat) {
                }

                public IWeakIdentityMap getConcurrentCappedWeakIdentityMap(String kobjecttoblamekeymapname2) {
                    return null;
                }

                public Map getConcurrentCappedMap(String string) {
                    return null;
                }
            };
            counter = new IGuaranteedCounter(){

                public int next() {
                    return 0;
                }

                public int prev() {
                    return 0;
                }

                public void reset() {
                }

                public IGuaranteedCounter getNewInstance() {
                    return null;
                }

                public int peek() {
                    return 0;
                }

                public int getAndSet(int i) {
                    return 0;
                }
            };
        }
        concStatementToSQL = factory.getConcurrentCappedWeakIdentityMap("StatementToSQLMap");
        concStatementToBlameKey = factory.getConcurrentCappedWeakIdentityMap("StatementToBlameKeyMap");
        concRawToNorm = factory.getConcurrentWeakMap("rawToNormMap");
        sNormalizerConfigCounter = counter;
        sRawToNormalizedSQLThreadLocal = new ThreadLocal(){

            protected Object initialValue() {
                WeakHashMap weakHashMap = new WeakHashMap();
                RawToNormalizedSQLThreadLocalEntry entry = new RawToNormalizedSQLThreadLocalEntry(weakHashMap);
                return entry;
            }
        };
    }

    public StatementToSQLMappingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        String normalizedSqlForMetricName;
        Object statement = data.getInvocationReturnValueAsObject();
        if (statement == null) {
            return;
        }
        if (!(statement instanceof Statement)) {
            Assertion.wilyAssert("Expected a Statement");
            return;
        }
        if (data.getInvocationParameterCount() == 0) {
            Assertion.wilyAssert("No parameters are available");
            return;
        }
        Object sql = data.getInvocationParameterAsObject(this.sqlParameterIndex);
        String rawSQL = "null";
        if (sql != null) {
            rawSQL = sql.toString();
        }
        if ((normalizedSqlForMetricName = this.normalizeForMetricName(rawSQL)) == null) {
            Assertion.wilyAssert("Normalization didn't work");
            return;
        }
        String normalizedSqlForUserView = this.normalizeForUserView(rawSQL, normalizedSqlForMetricName);
        if (normalizedSqlForUserView == null) {
            Assertion.wilyAssert("Normalization didn't work");
            return;
        }
        String sqlType = (String)sStatementTypeMap.get(this.getProbeIdentification().getProbeMethodName());
        if (sqlType == null) {
            Assertion.wilyAssert("Couldn't figure out SQL statement type");
            return;
        }
        String rawSQLinMap = null;
        try {
            if (fConfiguration.shouldIncludeRawSQL()) {
                rawSQLinMap = rawSQL;
            }
        }
        catch (Exception exception) {}
        StatementToSQLMappingTracer.putMapping(statement, rawSQLinMap, normalizedSqlForMetricName, normalizedSqlForUserView, sqlType);
    }

    private static int getIndex(Object key) {
        return key.hashCode() & 0x1F;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putInStaticStatementMap(Object key, Object value) {
        WeakIdentityHashMap map;
        WeakIdentityHashMap weakIdentityHashMap = map = sStatementToSQLMaps[StatementToSQLMappingTracer.getIndex(key)];
        synchronized (weakIdentityHashMap) {
            map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putInStaticRawMap(Object key, Object value) {
        WeakHashMap map = sRawToNormalizedSQLMaps[StatementToSQLMappingTracer.getIndex(key)];
        key = CanonicalObjectPool.getCanonicalString((String)key);
        WeakHashMap weakHashMap = map;
        synchronized (weakHashMap) {
            map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getFromStaticStatementMap(Object key) {
        WeakIdentityHashMap map;
        WeakIdentityHashMap weakIdentityHashMap = map = sStatementToSQLMaps[StatementToSQLMappingTracer.getIndex(key)];
        synchronized (weakIdentityHashMap) {
            return map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getFromStaticRawMap(Object key) {
        WeakHashMap map;
        WeakHashMap weakHashMap = map = sRawToNormalizedSQLMaps[StatementToSQLMappingTracer.getIndex(key)];
        synchronized (weakHashMap) {
            return map.get(key);
        }
    }

    public static void putMapping(Object statement, String rawSQL, String sqlForMetricName, String sqlForUserView, String sqlType) {
        SQLAndTypeRecord rec = new SQLAndTypeRecord(rawSQL, sqlForMetricName, sqlForUserView, sqlType);
        concStatementToSQL.putWeak(statement, rec);
    }

    public static void putBlameMapping(Object statement, Object blameKey) {
        concStatementToBlameKey.putWeak(statement, blameKey);
    }

    private static WeakIdentityHashMap getThreadLocalMap() {
        return (WeakIdentityHashMap)sStatementToSQLThreadLocal.get();
    }

    private static WeakHashMap getRawToNormalizedThreadLocalMap() {
        return ((RawToNormalizedSQLThreadLocalEntry)sRawToNormalizedSQLThreadLocal.get()).getMap();
    }

    public static void putRawToNormalizedMapping(String raw, String normalized) {
        StatementToSQLMappingTracer.putInStaticRawMap(raw, normalized);
        StatementToSQLMappingTracer.getRawToNormalizedThreadLocalMap().put(raw, normalized);
    }

    public static String getRawToNormalizedMapping(String raw) {
        WeakHashMap localMap = StatementToSQLMappingTracer.getRawToNormalizedThreadLocalMap();
        String answer = (String)localMap.get(raw);
        if (answer == null && (answer = (String)StatementToSQLMappingTracer.getFromStaticRawMap(raw)) != null) {
            raw = CanonicalObjectPool.getCanonicalString(raw);
            localMap.put(raw, answer);
        }
        return answer;
    }

    private String normalizeForMetricName(String sql) {
        String answer = StatementNormalizer.normalizeSQL(sql, fConfiguration.getNormalizedMaxSQLLength());
        return answer;
    }

    private String normalizeForUserView(String sql, String normalizedForMetricName) {
        String answer = StatementNormalizer.normalizeSQLForUserView(sql, normalizedForMetricName, fConfiguration.getNormalizedMaxSQLLength());
        return answer;
    }

    public static String getSQL(Statement statement) {
        return StatementToSQLMappingTracer.getSQL(statement, true);
    }

    public static String getSQL(Statement statement, boolean forMetricName) {
        SQLAndTypeRecord record;
        String result = null;
        if (statement != null && (record = (SQLAndTypeRecord)concStatementToSQL.getWeak(statement)) != null) {
            result = forMetricName ? record.fSQLForMetricName : record.fSQLForUserView;
        }
        return result;
    }

    public static String getRawSQL(Statement statement) {
        SQLAndTypeRecord record;
        String result = null;
        if (statement != null && (record = (SQLAndTypeRecord)concStatementToSQL.getWeak(statement)) != null) {
            result = record.fRawSQL;
        }
        return result;
    }

    public static String getSQLType(Statement statement) {
        SQLAndTypeRecord record;
        if (statement != null && (record = (SQLAndTypeRecord)concStatementToSQL.getWeak(statement)) != null) {
            return record.fType;
        }
        return null;
    }

    public static Object getBlameKey(Statement statement) {
        if (statement != null) {
            return concStatementToBlameKey.getWeak(statement);
        }
        return null;
    }

    public boolean canCacheInvocationData() {
        return true;
    }

    public boolean canCacheTracerInstances() {
        return true;
    }

    public boolean canCacheComponentNames() {
        return true;
    }

    public static void putMapping(Object shouldBeStatement, String normalizedSQLForMetricName, String normalizedSQLForUserView, String kdynamicsqlstring) {
        StatementToSQLMappingTracer.putMapping(shouldBeStatement, null, normalizedSQLForMetricName, normalizedSQLForUserView, kdynamicsqlstring);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearRawToNormalizeCache() {
        sNormalizerConfigCounter.next();
        int i = 0;
        while (i < 32) {
            WeakHashMap map;
            WeakHashMap weakHashMap = map = sRawToNormalizedSQLMaps[i];
            synchronized (weakHashMap) {
                map.clear();
            }
            ++i;
        }
    }

    private static final class RawToNormalizedSQLThreadLocalEntry {
        private int fCurrentConfig;
        private WeakHashMap fMap;

        public RawToNormalizedSQLThreadLocalEntry(WeakHashMap weakHashMap) {
            this.fMap = weakHashMap;
            this.fCurrentConfig = sNormalizerConfigCounter.peek();
        }

        public WeakHashMap getMap() {
            int current = sNormalizerConfigCounter.peek();
            if (current != this.fCurrentConfig) {
                this.fMap.clear();
                this.fCurrentConfig = current;
            }
            return this.fMap;
        }
    }

    private static final class SQLAndTypeRecord {
        public String fSQLForMetricName;
        public String fSQLForUserView;
        public String fType;
        public String fRawSQL;

        public SQLAndTypeRecord(String rawSQL, String sqlForMetricName, String sqlForUserView, String type) {
            this.fRawSQL = rawSQL;
            this.fSQLForMetricName = sqlForMetricName;
            this.fSQLForUserView = sqlForUserView;
            this.fType = type;
        }
    }
}

