/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.event;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.WeakHashMap;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.collection.TransformedCollection;
import org.apache.commons.collections.iterators.ArrayIterator;

public class WeakReferenceCollection
extends TransformedCollection
implements Collection {
    public static Collection decorate(Collection collection) {
        return new WeakReferenceCollection(collection);
    }

    private WeakReferenceCollection(Collection collection) {
        super(collection, (Transformer)new ToReferenceTransformer());
    }

    public boolean remove(Object arg0) {
        this.gc();
        Reference reference = this.getTransformer().getReference(arg0);
        if (reference == null) {
            return false;
        }
        return this.removeReference(reference);
    }

    public int size() {
        return this.getTransformer().getNumberOfLiveReferences();
    }

    public Object[] toArray(Object[] a) {
        ArrayList result = new ArrayList(this.size());
        Object[] refArray = this.collection.toArray();
        int atRef = 0;
        while (atRef < refArray.length) {
            Reference reference = (Reference)refArray[atRef];
            Object o = reference.get();
            if (o != null) {
                result.add(o);
            }
            ++atRef;
        }
        return result.toArray(a);
    }

    public Object[] toArray() {
        ArrayList result = new ArrayList(this.size());
        Object[] refArray = this.collection.toArray();
        int atRef = 0;
        while (atRef < refArray.length) {
            Reference reference = (Reference)refArray[atRef];
            Object o = reference.get();
            if (o != null) {
                result.add(o);
            }
            ++atRef;
        }
        return result.toArray();
    }

    protected boolean removeReference(Object reference) {
        return super.remove(reference);
    }

    private ToReferenceTransformer getTransformer() {
        return (ToReferenceTransformer)this.transformer;
    }

    public boolean contains(Object arg0) {
        this.gc();
        return super.contains((Object)this.getTransformer().getReference(arg0));
    }

    private void gc() {
        this.getTransformer().gc(this.collection);
    }

    public Iterator iterator() {
        this.gc();
        return new ArrayIterator((Object)this.toArray());
    }

    private static final class ToReferenceTransformer
    implements Transformer {
        public WeakHashMap object2reference = new WeakHashMap();
        private ReferenceQueue referenceQueue = new ReferenceQueue();

        public Object transform(Object o) {
            WeakReference<Object> reference = new WeakReference<Object>(o, this.referenceQueue);
            this.object2reference.put(o, reference);
            return reference;
        }

        public Reference getReference(Object arg0) {
            return (Reference)this.object2reference.get(arg0);
        }

        public int getNumberOfLiveReferences() {
            return this.object2reference.size();
        }

        public void gc(Collection referenceCollection) {
            Reference reference;
            while ((reference = this.referenceQueue.poll()) != null) {
                referenceCollection.remove(reference);
            }
        }
    }
}

