/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.feedback;

import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.LoggingHelper;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SeverityLevel;

public class DelegatingFeedbackChannel
implements IModuleFeedbackChannel {
    final IModuleFeedbackChannel fDelegate;
    final Module fModule;

    public DelegatingFeedbackChannel(IModuleFeedbackChannel delegate, Module module) {
        this.fDelegate = delegate;
        this.fModule = module;
    }

    public void debug(String message) {
        this.fDelegate.debug(this.fModule, message);
    }

    public void debug(String message, Throwable t) {
        this.fDelegate.debug(this.fModule, message, t);
    }

    public void debug(Throwable t) {
        this.fDelegate.debug(this.fModule, null, t);
    }

    public void debug(Module module, String message) {
        this.fDelegate.debug(module, message);
    }

    public void debug(Module module, String message, Throwable t) {
        this.fDelegate.debug(module, message, t);
    }

    public void error(String message) {
        this.fDelegate.error(this.fModule, message);
        LoggingHelper.updateErrorCount();
    }

    public void error(String message, Throwable t) {
        this.fDelegate.error(this.fModule, message, t);
        LoggingHelper.updateErrorCount();
    }

    public void error(Throwable t) {
        this.fDelegate.error(this.fModule, null, t);
        LoggingHelper.updateErrorCount();
    }

    public void error(Module module, String message) {
        this.fDelegate.error(module, message);
        LoggingHelper.updateErrorCount();
    }

    public void error(Module module, String message, Throwable t) {
        this.fDelegate.error(module, message, t);
        LoggingHelper.updateErrorCount();
    }

    public String getApplicationName() {
        return this.fDelegate.getApplicationName();
    }

    public SeverityLevel getEffectiveLevel(Module module) {
        return this.fDelegate.getEffectiveLevel(module);
    }

    public SeverityLevel getLevel(Module module) {
        return this.fDelegate.getLevel(module);
    }

    public String getModuleName() {
        return this.fModule.getName();
    }

    public void info(String message) {
        this.fDelegate.info(this.fModule, message);
    }

    public void info(String message, Throwable t) {
        this.fDelegate.info(this.fModule, message, t);
    }

    public void info(Module module, String message) {
        this.fDelegate.info(module, message);
    }

    public void info(Module module, String message, Throwable t) {
        this.fDelegate.info(module, message, t);
    }

    public boolean isDebugEnabled() {
        return this.fDelegate.isDebugEnabled(this.fModule);
    }

    public boolean isDebugEnabled(Module module) {
        return this.fDelegate.isDebugEnabled(module);
    }

    public boolean isErrorEnabled(Module module) {
        return this.fDelegate.isErrorEnabled(module);
    }

    public boolean isInfoEnabled(Module module) {
        return this.fDelegate.isErrorEnabled(module);
    }

    public boolean isLogEnabled(SeverityLevel severity, Module module) {
        return this.fDelegate.isLogEnabled(severity, module);
    }

    public boolean isTraceEnabled() {
        return this.fDelegate.isTraceEnabled(this.fModule);
    }

    public boolean isTraceEnabled(Module module) {
        return this.fDelegate.isTraceEnabled(module);
    }

    public boolean isVerboseEnabled() {
        return this.fDelegate.isVerboseEnabled(this.fModule);
    }

    public boolean isVerboseEnabled(Module module) {
        return this.fDelegate.isVerboseEnabled(module);
    }

    public boolean isWarningEnabled(Module module) {
        return this.fDelegate.isWarningEnabled(module);
    }

    public void log(SeverityLevel severity, String message) {
        this.fDelegate.log(severity, this.fModule, message);
        this.updateCount(severity);
    }

    private void updateCount(SeverityLevel severity) {
        if (severity.getLevelNumber() == 1) {
            LoggingHelper.updateErrorCount();
        } else if (severity.getLevelNumber() == 2) {
            LoggingHelper.updateWarningCount();
        }
    }

    public void log(SeverityLevel severity, String message, Throwable t) {
        this.fDelegate.log(severity, this.fModule, message, t);
        this.updateCount(severity);
    }

    public void log(SeverityLevel severity, Module module, String message) {
        this.fDelegate.log(severity, module, message);
        this.updateCount(severity);
    }

    public void log(SeverityLevel severity, Module module, String message, Throwable t) {
        this.fDelegate.log(severity, module, message, t);
        this.updateCount(severity);
    }

    public void logImmediate(SeverityLevel severity, Module module, String message) {
        this.fDelegate.logImmediate(severity, module, message);
        this.updateCount(severity);
    }

    public void logImmediate(SeverityLevel severity, Module module, String message, Throwable t) {
        this.fDelegate.logImmediate(severity, module, message, t);
        this.updateCount(severity);
    }

    public void setLevel(SeverityLevel level, Module module) {
        this.fDelegate.setLevel(level, module);
    }

    public void trace(String message) {
        this.fDelegate.trace(this.fModule, message);
    }

    public void trace(Module module, String message) {
        this.fDelegate.trace(module, message);
    }

    public void trace(Module module, String message, Throwable t) {
        this.fDelegate.trace(module, message, t);
    }

    public void verbose(String message) {
        this.fDelegate.verbose(this.fModule, message);
    }

    public void verbose(String message, Throwable t) {
        this.fDelegate.verbose(this.fModule, message, t);
    }

    public void verbose(Throwable t) {
        this.fDelegate.verbose(this.fModule, null, t);
    }

    public void verbose(Module module, String message) {
        this.fDelegate.verbose(module, message);
    }

    public void verbose(Module module, String message, Throwable t) {
        this.fDelegate.verbose(module, message, t);
    }

    public void warn(String message) {
        this.fDelegate.warn(this.fModule, message);
        LoggingHelper.updateWarningCount();
    }

    public void warn(String message, Throwable t) {
        this.fDelegate.warn(this.fModule, message, t);
        LoggingHelper.updateWarningCount();
    }

    public void warn(Module module, String message) {
        this.fDelegate.warn(module, message);
        LoggingHelper.updateWarningCount();
    }

    public void warn(Module module, String message, Throwable t) {
        this.fDelegate.warn(module, message, t);
        LoggingHelper.updateWarningCount();
    }
}

