/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.xmlserialization;

import com.wily.util.xmlserialization.ICustomXmlizable;
import com.wily.util.xmlserialization.IXmlReferenceable;
import com.wily.util.xmlserialization.IXmlWriter;
import com.wily.util.xmlserialization.IXmlizable;
import com.wily.util.xmlserialization.XmlException;
import com.wily.utilities.properties.Messages;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Stack;

public class XmlWriter
implements IXmlWriter {
    private Writer writer;
    private Stack stack;
    private StringBuffer attrs;
    private boolean empty;
    private boolean closed;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public XmlWriter(Writer writer) {
        this.writer = writer;
        this.closed = true;
        this.stack = new Stack();
    }

    public void startElement(String name) throws XmlException {
        try {
            this.closeOpeningTag();
            this.closed = false;
            this.writer.write("<");
            this.writer.write(name);
            this.stack.add(name);
            this.empty = true;
        }
        catch (IOException ioe) {
            throw new XmlException(ioe);
        }
    }

    public void writeElement(String name, IXmlizable element) throws XmlException {
        this.startElement(name);
        this.writeElement(element);
        this.endElement();
    }

    public void writeElement(IXmlizable element) throws XmlException {
        if (element == null) {
            this.writeText("NULL");
        } else if (element instanceof ICustomXmlizable) {
            ((ICustomXmlizable)element).writeXML(this);
        } else {
            this.writeJavaObjectByReflection(element);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void writeJavaObjectByReflection(Object obj) throws XmlException {
        try {
            this.startElement("Object");
            this.writeAttribute("Type", obj.getClass().getName());
            if (obj instanceof IXmlReferenceable) {
                this.writeAttribute("UID", ((IXmlReferenceable)obj).getXmlReferenceUID());
            }
            currentClass = obj.getClass();
            if (true) ** GOTO lbl103
            do {
                fields = currentClass.getDeclaredFields();
                i = 0;
                while (i < fields.length) {
                    block38: {
                        f = fields[i];
                        if (Modifier.isTransient(f.getModifiers()) || Modifier.isStatic(f.getModifiers())) break block38;
                        f.setAccessible(true);
                        this.startElement("Field");
                        type = f.getType();
                        this.writeAttribute("Name", this.stripFieldNamePrefix(f.getName()));
                        this.writeAttribute("Type", type.getName());
                        this.startElement("Value");
                        if (type.isPrimitive()) ** GOTO lbl-1000
                        v0 = XmlWriter.class$1;
                        if (v0 == null) {
                            try {
                                v0 = Class.forName("java.lang.Number");
                            }
                            catch (ClassNotFoundException v1) {
                                throw new NoClassDefFoundError(v1.getMessage());
                            }
                        }
                        if (type.isAssignableFrom(v0)) ** GOTO lbl-1000
                        v2 = XmlWriter.class$2;
                        if (v2 == null) {
                            try {
                                v2 = Class.forName("java.lang.String");
                            }
                            catch (ClassNotFoundException v3) {
                                throw new NoClassDefFoundError(v3.getMessage());
                            }
                        }
                        if (type.equals(v2)) lbl-1000:
                        // 3 sources

                        {
                            this.writeText((val = f.get(obj)) == null ? "NULL" : val.toString());
                        } else if (type.isArray()) {
                            arr = f.get(obj);
                            if (arr == null) {
                                this.writeText("NULL");
                            } else {
                                this.startElement("Array");
                                arrLen = Array.getLength(arr);
                                this.writeAttribute("Length", arrLen);
                                j = 0;
                                while (j < arrLen) {
                                    this.writeJavaObjectByReflection(Array.get(arr, j));
                                    ++j;
                                }
                                this.endElement();
                            }
                        } else {
                            v4 = XmlWriter.class$3;
                            if (v4 == null) {
                                try {
                                    v4 = Class.forName("java.util.List");
                                }
                                catch (ClassNotFoundException v5) {
                                    throw new NoClassDefFoundError(v5.getMessage());
                                }
                            }
                            if (v4.isAssignableFrom(type)) {
                                list = (List)f.get(obj);
                                if (list == null) {
                                    this.writeText("NULL");
                                } else {
                                    this.startElement("List");
                                    arrLen = list.size();
                                    this.writeAttribute("Length", arrLen);
                                    j = 0;
                                    while (j < arrLen) {
                                        this.writeJavaObjectByReflection(list.get(j));
                                        ++j;
                                    }
                                    this.endElement();
                                }
                            } else {
                                v6 = XmlWriter.class$4;
                                if (v6 == null) {
                                    try {
                                        v6 = Class.forName("com.wily.util.xmlserialization.IXmlReferenceable");
                                    }
                                    catch (ClassNotFoundException v7) {
                                        throw new NoClassDefFoundError(v7.getMessage());
                                    }
                                }
                                if (v6.isAssignableFrom(type)) {
                                    this.writeElementReference((IXmlReferenceable)f.get(obj));
                                } else {
                                    v8 = XmlWriter.class$5;
                                    if (v8 == null) {
                                        try {
                                            v8 = Class.forName("com.wily.util.xmlserialization.IXmlizable");
                                        }
                                        catch (ClassNotFoundException v9) {
                                            throw new NoClassDefFoundError(v9.getMessage());
                                        }
                                    }
                                    if (v8.isAssignableFrom(type)) {
                                        this.writeElement((IXmlizable)f.get(obj));
                                    } else {
                                        throw new XmlException(Messages.getString("XmlWriter.UnsupportedTypeError_Log", (Object)type.getName(), (Object)obj.getClass().getName(), (Object)f.getName()));
                                    }
                                }
                            }
                        }
                        this.endElement();
                        this.endElement();
                    }
                    ++i;
                }
                currentClass = currentClass.getSuperclass();
lbl103:
                // 2 sources

                if ((v10 = XmlWriter.class$0) != null) continue;
                try {
                    v10 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException v11) {
                    throw new NoClassDefFoundError(v11.getMessage());
                }
            } while (!currentClass.equals(v10));
            this.endElement();
        }
        catch (IllegalAccessException e) {
            throw new XmlException(e);
        }
    }

    private String stripFieldNamePrefix(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("f")) {
            return name.substring("f".length());
        }
        return null;
    }

    public void writeElementReference(String name, IXmlReferenceable element) throws XmlException {
        this.startElement(name);
        this.writeElementReference(element);
        this.endElement();
    }

    public void writeElementReference(IXmlReferenceable element) throws XmlException {
        if (element == null) {
            this.writeText("NULL");
        } else {
            this.startElement("Reference");
            this.writeAttribute("TargetType", element.getClass().getName());
            this.writeAttribute("TargetUID", element.getXmlReferenceUID());
            this.endElement();
        }
    }

    public void writeAttribute(String attr, String value) throws XmlException {
        if (this.attrs == null) {
            this.attrs = new StringBuffer();
        }
        this.attrs.append(" ");
        this.attrs.append(attr);
        this.attrs.append("=\"");
        this.attrs.append(XmlWriter.escapeXml(value));
        this.attrs.append("\"");
    }

    public void writeAttribute(String attr, long value) throws XmlException {
        this.writeAttribute(attr, Long.toString(value));
    }

    public void writeAttribute(String attr, int value) throws XmlException {
        this.writeAttribute(attr, Integer.toString(value));
    }

    public void writeAttribute(String attr, short value) throws XmlException {
        this.writeAttribute(attr, Short.toString(value));
    }

    public void writeAttribute(String attr, byte value) throws XmlException {
        this.writeAttribute(attr, Byte.toString(value));
    }

    public void writeAttribute(String attr, boolean value) throws XmlException {
        this.writeAttribute(attr, Boolean.toString(value));
    }

    public void writeAttribute(String attr, float value) throws XmlException {
        this.writeAttribute(attr, Float.toString(value));
    }

    public void writeAttribute(String attr, double value) throws XmlException {
        this.writeAttribute(attr, Double.toString(value));
    }

    public void endElement() throws XmlException {
        try {
            if (this.stack.empty()) {
                throw new XmlException(Messages.getString("XmlWriter.XmlException_Log"));
            }
            String name = (String)this.stack.pop();
            if (name != null) {
                if (this.empty) {
                    this.writeAttributes();
                    this.writer.write("/>");
                } else {
                    this.writer.write("</");
                    this.writer.write(name);
                    this.writer.write(">");
                }
                this.empty = false;
                this.closed = true;
            }
        }
        catch (IOException ioe) {
            throw new XmlException(ioe);
        }
    }

    public void writeText(String text) throws XmlException {
        try {
            this.closeOpeningTag();
            this.empty = false;
            this.writer.write(XmlWriter.escapeXml(text));
        }
        catch (IOException ioe) {
            throw new XmlException(ioe);
        }
    }

    public void close() throws XmlException {
        if (!this.stack.empty()) {
            throw new XmlException(Messages.getString("XmlWriter.UnclosedTagsError_Log", this.stack.pop()));
        }
    }

    private void closeOpeningTag() throws IOException {
        if (!this.closed) {
            this.writeAttributes();
            this.closed = true;
            this.writer.write(">");
        }
    }

    private void writeAttributes() throws IOException {
        if (this.attrs != null) {
            this.writer.write(this.attrs.toString());
            this.attrs.setLength(0);
            this.empty = false;
        }
    }

    private static String escapeXml(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer(s.length());
        char[] chars = s.toCharArray();
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case '&': {
                    buff.append("&amp;");
                    break;
                }
                case '<': {
                    buff.append("&lt;");
                    break;
                }
                case '>': {
                    buff.append("&gt;");
                    break;
                }
                case '\"': {
                    buff.append("&quot;");
                    break;
                }
                case '\'': {
                    buff.append("&apos;");
                    break;
                }
                default: {
                    buff.append(chars[i]);
                }
            }
            ++i;
        }
        return buff.toString();
    }
}

