/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.platform.linux;

import com.wily.introscope.agent.platform.ADefaultPlatformStatisticsBackEnd;
import com.wily.introscope.agent.platform.PlatformLibraryException;
import com.wily.introscope.agent.platform.PlatformLibraryVersionMismatchException;
import com.wily.introscope.agent.platform.PlatformStatUnavailableException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;

public final class LinuxPlatformStatisticsBackEnd
extends ADefaultPlatformStatisticsBackEnd {
    private String fName;
    private IModuleFeedbackChannel fFeedback;
    private String fCPUNamePrefix;
    private int[] fCPUIndexMapper;
    private int fCPUCount;
    private static final String kProcDirName = "/proc";
    private static final String kStatDirName = "/stat";
    private static final String kStatFileName = "/proc/stat";
    private static final String kCpuPrefix = "cpu";
    private static final int kCurrentLinuxPlatformStatsProtocolVersion = 5;

    public LinuxPlatformStatisticsBackEnd(String platformMonitorName, IModuleFeedbackChannel feedback, IStringLocalizer lclizr) throws PlatformLibraryVersionMismatchException {
        super(platformMonitorName, 5);
        this.fName = platformMonitorName;
        this.fFeedback = feedback;
    }

    public int IPlatformStatisticsBackEnd_getProtocolVersion() {
        return this.getProtocolVersion();
    }

    void initialize() throws PlatformLibraryException {
        this.init();
        this.fCPUNamePrefix = kCpuPrefix;
        this.fCPUIndexMapper = this.getCPUIndexMap();
        this.fCPUCount = this.fCPUIndexMapper.length;
    }

    void terminate() throws PlatformLibraryException {
        this.term();
    }

    int getInstalledCPUCount() {
        return this.fCPUCount;
    }

    int mapLinearZeroBasedCPUIndexToOSName(int linearZeroBasedIndex) throws PlatformLibraryException {
        Assertion.wilyAssert(linearZeroBasedIndex >= 0 && linearZeroBasedIndex <= this.fCPUIndexMapper.length - 1);
        return this.fCPUIndexMapper[linearZeroBasedIndex];
    }

    long[] getAggregateCPUUsage(int linearZeroBasedIndex) throws PlatformStatUnavailableException, PlatformLibraryException {
        return this.getAggregateCPUUsage(this.fCPUNamePrefix + this.mapLinearZeroBasedCPUIndexToOSName(linearZeroBasedIndex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getCPUIndexMap() throws PlatformLibraryException {
        BufferedReader rdr = null;
        try {
            File statFile = new File(kStatFileName);
            rdr = new LineNumberReader(new BufferedReader(new FileReader(statFile)));
            String line = null;
            int[] cpuMap = new int[256];
            int cpuIndex = 0;
            while ((line = ((LineNumberReader)rdr).readLine()) != null) {
                String cpuStr = this.getCPUString(line);
                if (cpuStr == null) continue;
                try {
                    int cpuNum = Integer.parseInt(cpuStr);
                    cpuMap[cpuIndex++] = cpuNum;
                }
                catch (NumberFormatException e) {}
            }
            int[] newArray = new int[cpuIndex];
            System.arraycopy(cpuMap, 0, newArray, 0, cpuIndex);
            int[] nArray = newArray;
            return nArray;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            this.safeReportError(t, "Agent_Platform_Monitor_CPU_Name_Mapping_Failed_Message");
            int[] nArray = new int[]{};
            return nArray;
        }
        finally {
            if (rdr != null) {
                try {
                    rdr.close();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        this.fFeedback.error(t);
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable t2) {}
                }
            }
        }
    }

    private String getCPUString(String procFileLine) {
        int cpuIndex;
        if (procFileLine != null && (cpuIndex = procFileLine.indexOf(kCpuPrefix)) >= 0) {
            int startScan;
            int scanIndex = startScan = cpuIndex + kCpuPrefix.length();
            while (Character.isDigit(procFileLine.charAt(scanIndex))) {
                ++scanIndex;
            }
            if (scanIndex > cpuIndex) {
                return procFileLine.substring(startScan, scanIndex);
            }
        }
        return null;
    }

    private void safeReportError(Throwable t, String key) {
        try {
            this.fFeedback.error(t);
            this.fFeedback.verbose(t);
            throw new PlatformLibraryException(t.toString(), (ILocalizableMessage)new FormattedLocalizableMessage(key, this.fName, false));
        }
        catch (ThreadDeath td2) {
            throw td2;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private native int getProtocolVersion();

    private native void init() throws PlatformLibraryException;

    private native void term() throws PlatformLibraryException;

    native int getProcessCPUUsage() throws PlatformStatUnavailableException;

    native int getTotalClockTicks() throws PlatformStatUnavailableException;

    native int getProcessID() throws PlatformStatUnavailableException;

    native int getParentProcessID() throws PlatformStatUnavailableException;

    private native long[] getAggregateCPUUsage(String var1) throws PlatformStatUnavailableException;

    public native boolean isThreadCpuTimeEnabled();

    public native long getThreadCpuTime();
}

