/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import com.wily.properties.KUICommonStringsKeys;
import com.wily.ui.IGenericServices;
import com.wily.ui.WilyIntegerTextField;
import com.wily.util.validate.ValidationException;
import com.wily.util.validate.ValidationInvalidBoundedLongException;
import com.wily.wilyassert.Assertion;

public class WilyTimeTextField
extends WilyIntegerTextField
implements KUICommonStringsKeys {
    private static final long serialVersionUID = -4441576693310461313L;
    public static final int kMilliseconds = 1;
    public static final int kSeconds = 1000;
    public static final int kMinutes = 60000;
    public static final int kHours = 3600000;
    private int fUnitsToMillisecondsRatio;
    private static final String kWilyTimeTextFieldContentsStateKey = "WilyTimeTextField_Contents";

    protected WilyTimeTextField() {
        Assertion.unimplemented("Must at least specify GenericServices");
    }

    public WilyTimeTextField(IGenericServices genericServices, int units) {
        this(genericServices, 0, units);
    }

    public WilyTimeTextField(IGenericServices genericServices, int initialValue, int units) {
        super(genericServices);
        this.setUnits(units);
        this.setIntValue(initialValue);
    }

    public WilyTimeTextField(IGenericServices genericServices, int initialValue, int units, int columns) {
        super(genericServices, columns);
        this.setUnits(units);
        this.setIntValue(initialValue);
    }

    protected String getContentsStateKey() {
        return kWilyTimeTextFieldContentsStateKey;
    }

    public void setUnits(int units) {
        int adjustedTime = (this.getTimeValueInMilliseconds() + units / 2) / units;
        if (adjustedTime == 0) {
            adjustedTime = 1;
        }
        this.checkCanHandleTimeAndUnit(adjustedTime, units);
        this.fUnitsToMillisecondsRatio = units;
        this.setTimeValueInMilliseconds(adjustedTime * units);
    }

    protected int getUnits() {
        return this.fUnitsToMillisecondsRatio;
    }

    public void setTimeValueInMilliseconds(int value) {
        this.checkCanHandleTimeAndUnit(value, 1);
        this.setText(Integer.toString(value / this.getUnits()));
    }

    public int getTimeValueInMilliseconds() {
        return this.getIntegerObjectValue() * this.getUnits();
    }

    public void setTimeValueInSeconds(int value) {
        this.checkCanHandleTimeAndUnit(value, 1000);
        this.setTimeValueInMilliseconds(value * 1000);
    }

    public int getTimeValueInSeconds() {
        return this.getTimeValueInMilliseconds() / 1000;
    }

    public int getTimeValueInMinutes() {
        return this.getTimeValueInMilliseconds() / 60000;
    }

    protected int getUnitsToMillisecondsRatio() {
        return this.getUnits();
    }

    protected int getMaxTimeValueForUnit(int units) {
        return Integer.MAX_VALUE / units;
    }

    private void checkCanHandleTimeAndUnit(int value, int unit) {
        if (value < 0) {
            throw new IllegalArgumentException("Time appears to be negative");
        }
        if (value > this.getMaxTimeValueForUnit(unit)) {
            throw new IllegalArgumentException("Time exceeds limit for given unit: " + this.getMaxTimeValueForUnit(unit));
        }
    }

    public void IValidatable_validate(int validationConstraints) throws ValidationException {
        super.IValidatable_validate(validationConstraints);
        try {
            this.checkCanHandleTimeAndUnit(this.getTimeValueInMilliseconds(), this.fUnitsToMillisecondsRatio);
        }
        catch (NumberFormatException nfe) {
            throw new ValidationInvalidBoundedLongException(0L, this.getMaxTimeValueForUnit(this.fUnitsToMillisecondsRatio));
        }
        catch (IllegalArgumentException iae) {
            throw new ValidationInvalidBoundedLongException(0L, this.getMaxTimeValueForUnit(this.fUnitsToMillisecondsRatio));
        }
    }
}

