/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import com.wily.ui.ContainingBox;
import com.wily.ui.RealPoint;
import com.wily.util.IComparer;
import com.wily.util.Sorter;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class XYPlot
implements IComparer {
    private static int fGrowBy = 5;
    private RealPoint[] fPoints;
    private ContainingBox fClipWindow;
    private int fCurrentIndex = 0;
    private boolean fGrowable;

    public XYPlot() {
        this(0, true);
    }

    public XYPlot(int numPoints) {
        this(numPoints, false);
    }

    public XYPlot(int numPoints, boolean growable) {
        this.fGrowable = growable;
        this.fPoints = new RealPoint[numPoints];
        this.fClipWindow = new ContainingBox(0.0f, 0.0f, 1.0f, 1.0f);
    }

    public void addPoint(RealPoint p) {
        if (this.fCurrentIndex == this.fPoints.length) {
            if (this.fGrowable) {
                RealPoint[] old = this.fPoints;
                this.fPoints = new RealPoint[this.fPoints.length + fGrowBy];
                System.arraycopy(old, 0, this.fPoints, 0, old.length);
            } else {
                this.fCurrentIndex = 0;
            }
        }
        this.fPoints[this.fCurrentIndex] = p;
        ++this.fCurrentIndex;
    }

    public void addPoint(int x, int y) {
        this.addPoint(new RealPoint(x, y));
    }

    public void setClipWindow(float xMin, float yMin, float xMax, float yMax) {
        this.setClipWindow(new ContainingBox(xMin, yMin, xMax, yMax));
    }

    public void setClipWindow(ContainingBox box) {
        this.fClipWindow = box;
    }

    public void clipPoints() {
        Vector<RealPoint> newPoints = new Vector<RealPoint>();
        for (int i = 0; i < this.fPoints.length; ++i) {
            if (!this.fClipWindow.containsPoint(this.fPoints[i])) continue;
            newPoints.addElement(this.fPoints[i]);
        }
        this.fPoints = new RealPoint[newPoints.size()];
        newPoints.copyInto(this.fPoints);
    }

    public void sortPoints() {
        Sorter.sort(this.fPoints, (IComparer)this);
    }

    public void drawPoints(Graphics g, Rectangle destinationWindow) {
        Point[] points = this.getTransformedPoints(destinationWindow);
        for (int i = 0; i < points.length; ++i) {
            g.drawLine(points[i].x, points[i].y, points[i].x, points[i].y);
        }
    }

    public void drawLines(Graphics g, Rectangle destinationWindow) {
        Point[] points = this.getTransformedPoints(destinationWindow);
        for (int i = 0; i < points.length - 1; ++i) {
            g.drawLine(points[i].x, points[i].y, points[i + 1].x, points[i + 1].y);
        }
    }

    private Point[] getTransformedPoints(Rectangle rect) {
        int y;
        int x;
        int i;
        Vector<Point> points = new Vector<Point>();
        double xRatio = (float)rect.width / this.fClipWindow.getxSize();
        double xOffset = (double)rect.x - xRatio * (double)this.fClipWindow.getxMin();
        double yRatio = -((float)rect.height / this.fClipWindow.getySize());
        double yOffset = (double)(rect.y + rect.height) - yRatio * (double)this.fClipWindow.getyMin();
        for (i = this.fCurrentIndex; i < this.fPoints.length; ++i) {
            if (this.fPoints[i] == null) continue;
            x = (int)((double)this.fPoints[i].x * xRatio + xOffset);
            y = (int)((double)this.fPoints[i].y * yRatio + yOffset);
            points.addElement(new Point(x, y));
        }
        for (i = 0; i < this.fCurrentIndex; ++i) {
            if (this.fPoints[i] == null) continue;
            x = (int)((double)this.fPoints[i].x * xRatio + xOffset);
            y = (int)((double)this.fPoints[i].y * yRatio + yOffset);
            points.addElement(new Point(x, y));
        }
        Object[] transPoints = new Point[points.size()];
        points.copyInto(transPoints);
        return transPoints;
    }

    public boolean lessThan(Object obj1, Object obj2) {
        RealPoint pt1 = (RealPoint)obj1;
        RealPoint pt2 = (RealPoint)obj2;
        return pt1.x < pt2.x;
    }

    public boolean equalTo(Object obj1, Object obj2) {
        RealPoint pt1 = (RealPoint)obj1;
        RealPoint pt2 = (RealPoint)obj2;
        return pt1.x == pt2.x && pt1.y == pt2.y;
    }
}

