/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.context;

import com.wily.ui.WilyUIUtilities;
import com.wily.ui.context.IContextualMenuProvider;
import com.wily.ui.swing.ExtendedJMenu;
import com.wily.wilyassert.SwingAssertion;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ContextualMenuHelper
extends MouseAdapter {
    private Component fComponent;
    private ExtendedJMenu fCurrentContextualMenu = null;
    private Point fMousePressedPoint = null;

    public void mousePressed(MouseEvent event) {
        this.fMousePressedPoint = event.getPoint();
        this.checkMouseEventForPopup(event, this.fMousePressedPoint);
    }

    public void mouseReleased(MouseEvent event) {
        if (this.fMousePressedPoint == null) {
            this.fMousePressedPoint = event.getPoint();
        }
        this.checkMouseEventForPopup(event, this.fMousePressedPoint);
    }

    private void checkMouseEventForPopup(MouseEvent event, Point contextPoint) {
        Component source;
        if (event.isPopupTrigger() && (source = (Component)event.getSource()).isShowing()) {
            this.cleanupContextualMenuSync();
            this.showContextMenuIfNecessarySync(event);
        }
    }

    public void showContextMenuIfNecessarySync(MouseEvent event) {
        SwingAssertion.assertSwingSafe();
        this.initializeContextualMenuAndComponent(event.getComponent());
        if (this.fCurrentContextualMenu != null && this.fCurrentContextualMenu.getItemCount() > 0 && this.fComponent != null) {
            JPopupMenu popupMenu = this.fCurrentContextualMenu.getPopupMenu();
            popupMenu.addPopupMenuListener(new CancelListener(popupMenu));
            MenuSelectionManager.defaultManager().clearSelectedPath();
            popupMenu.show(event.getComponent(), event.getX(), event.getY());
        }
    }

    private void initializeContextualMenuAndComponent(Component clickedComponent) {
        Component targetComponent;
        for (targetComponent = clickedComponent; targetComponent != null && !(targetComponent instanceof IContextualMenuProvider); targetComponent = targetComponent.getParent()) {
        }
        if (targetComponent != null && targetComponent instanceof IContextualMenuProvider) {
            Point targetPoint = WilyUIUtilities.convertChildPointToParentPoint(clickedComponent, targetComponent, this.fMousePressedPoint);
            IContextualMenuProvider contextualCommandProvider = (IContextualMenuProvider)((Object)targetComponent);
            this.fCurrentContextualMenu = contextualCommandProvider.IContextualMenuProvider_getContextualMenu(targetPoint);
            this.fComponent = targetComponent;
        }
    }

    private void cleanupContextualMenuSync() {
        SwingAssertion.assertSwingSafe();
        UIManager.put("MenuUI.sharedActionMap", null);
    }

    public static void propogateContextualMenuHelper(Component topComponent) {
        SwingAssertion.assertSwingSafe();
        topComponent.addMouseListener(new ContextualMenuHelper());
        if (topComponent instanceof Container) {
            Container parentContainer = (Container)topComponent;
            int childCount = parentContainer.getComponentCount();
            Component[] children = parentContainer.getComponents();
            for (int i = 0; i < childCount; ++i) {
                ContextualMenuHelper.propogateContextualMenuHelper(children[i]);
            }
        }
    }

    private class CancelListener
    implements PopupMenuListener {
        JPopupMenu fPopupMenu;

        CancelListener(JPopupMenu popupMenu) {
            this.fPopupMenu = popupMenu;
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
            this.cleanup();
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.cleanup();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ContextualMenuHelper.this.cleanupContextualMenuSync();
                }
            });
        }

        private void cleanup() {
            if (this.fPopupMenu != null) {
                this.fPopupMenu.removePopupMenuListener(this);
                this.fPopupMenu = null;
            }
        }
    }
}

