/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.selection;

import com.wily.ui.action.AExtendedActionWrapper;
import com.wily.ui.action.ExtendedActionException;
import com.wily.ui.action.IExtendedAction;
import com.wily.ui.selection.ASelectable;
import com.wily.ui.selection.ISelectionChangeInitiator;
import com.wily.ui.selection.ISelectionChangeListener;
import com.wily.ui.selection.Selection;
import com.wily.ui.selection.SelectionChangedEvent;
import com.wily.ui.selection.SelectionEnumeration;
import com.wily.ui.selection.SelectionFactory;
import com.wily.wilyassert.Assertion;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class SelectionBroker {
    private final Collection fSelectionChangeListeners = new HashSet();
    private Selection fCurrentSelection = kEmptySelection;
    private boolean fProcessingQueuedSelectionChanges = false;
    private boolean fForceQueueing;
    private final List fQueuedSelectionChangeRecords;
    public static final Selection kEmptySelection = new SelectionFactory().createSelection();

    public SelectionBroker() {
        this.setForceQueueing(false);
        this.fQueuedSelectionChangeRecords = new LinkedList();
    }

    public void addSelectionChangeListener(ISelectionChangeListener selectionChangeListener) {
        this.fSelectionChangeListeners.add(selectionChangeListener);
    }

    public void removeSelectionChangeListener(ISelectionChangeListener selectionChangeListener) {
        this.fSelectionChangeListeners.remove(selectionChangeListener);
    }

    public void mergeWithCurrentSelection(Object source, Selection selectionToMerge, boolean replaceTopLevelSelectablesOfSameType, ISelectionChangeInitiator selectionChangeInitiator) {
        Assertion.wilyAssert(selectionToMerge != null);
        this.queueSelectionChange(new QueuedMergeSelection(source, selectionToMerge, replaceTopLevelSelectablesOfSameType, selectionChangeInitiator));
        this.triggerProcessQueuedSelectionChanges();
    }

    public void replaceInCurrentSelection(Object source, Selection selectablesToReplace, Selection replacingSelectables, ISelectionChangeInitiator selectionChangeInitiator) {
        Assertion.wilyAssert(selectablesToReplace != null);
        Assertion.wilyAssert(replacingSelectables != null);
        this.queueSelectionChange(new QueuedReplaceInSelection(source, selectablesToReplace, replacingSelectables, selectionChangeInitiator));
        this.triggerProcessQueuedSelectionChanges();
    }

    public IExtendedAction makeForceQueueSelectionChangesAction(IExtendedAction extendedAction) {
        return new QueueSelectionChangesActionWrapper(extendedAction);
    }

    private synchronized void triggerProcessQueuedSelectionChanges() {
        if (!this.fProcessingQueuedSelectionChanges && !this.fForceQueueing) {
            this.fProcessingQueuedSelectionChanges = true;
            while (this.fQueuedSelectionChangeRecords.size() > 0) {
                this.handleQueuedSelectionChange((AQueuedSelectionChange)this.fQueuedSelectionChangeRecords.remove(0));
            }
            this.fProcessingQueuedSelectionChanges = false;
        }
    }

    private synchronized void setForceQueueing(boolean forceQueueing) {
        this.fForceQueueing = forceQueueing;
    }

    private void handleQueuedSelectionChange(AQueuedSelectionChange queuedSelectionChange) {
        Selection newSelection = queuedSelectionChange.getResultingSelection(this.fCurrentSelection);
        boolean vetoed = this.selectionChangeVetoed(newSelection);
        if (vetoed) {
            queuedSelectionChange.getSelectionChangeInitiator().ISelectionChangeInitiator_selectionChangeVetoed();
        } else {
            this.setCurrentSelectionAndNotify(queuedSelectionChange.getSource(), newSelection);
        }
    }

    private void queueSelectionChange(AQueuedSelectionChange queuedSelectionChange) {
        this.fQueuedSelectionChangeRecords.add(queuedSelectionChange);
    }

    private void setCurrentSelectionAndNotify(Object source, Selection selection) {
        this.fCurrentSelection = selection;
        this.notifySelectionChanged(source, this.fCurrentSelection);
    }

    public Selection getCurrentSelection() {
        return this.fCurrentSelection;
    }

    private void notifySelectionChanged(Object source, Selection newSelection) {
        Iterator selectionChangeListenerIterator = this.fSelectionChangeListeners.iterator();
        while (selectionChangeListenerIterator.hasNext()) {
            ISelectionChangeListener aSelectionChangeListener = (ISelectionChangeListener)selectionChangeListenerIterator.next();
            SelectionChangedEvent selectionChangeEvent = new SelectionChangedEvent(source, newSelection);
            aSelectionChangeListener.ISelectionChangeListener_selectionChanged(selectionChangeEvent);
        }
    }

    private boolean selectionChangeVetoed(Selection selection) {
        boolean vetoed = false;
        Iterator selectionChangeListenerIterator = this.fSelectionChangeListeners.iterator();
        while (selectionChangeListenerIterator.hasNext() && !vetoed) {
            ISelectionChangeListener aSelectionChangeListener = (ISelectionChangeListener)selectionChangeListenerIterator.next();
            vetoed = aSelectionChangeListener.ISelectionChangeListener_vetoSelectionChange(selection);
        }
        return vetoed;
    }

    private class QueueSelectionChangesActionWrapper
    extends AExtendedActionWrapper {
        private static final long serialVersionUID = -2388256060216409155L;

        public QueueSelectionChangesActionWrapper(IExtendedAction wrappedExtendedAction) {
            super(wrappedExtendedAction);
        }

        public void doTriggerAction(ActionEvent actionEvent) throws ExtendedActionException {
            SelectionBroker.this.setForceQueueing(true);
            try {
                super.doTriggerAction(actionEvent);
            }
            catch (ExtendedActionException eae) {
                SelectionBroker.this.setForceQueueing(false);
                SelectionBroker.this.triggerProcessQueuedSelectionChanges();
                throw eae;
            }
            SelectionBroker.this.setForceQueueing(false);
            SelectionBroker.this.triggerProcessQueuedSelectionChanges();
        }

        public void doUndoAction() throws ExtendedActionException {
            SelectionBroker.this.setForceQueueing(true);
            try {
                super.doUndoAction();
            }
            catch (ExtendedActionException eae) {
                SelectionBroker.this.setForceQueueing(false);
                SelectionBroker.this.triggerProcessQueuedSelectionChanges();
                throw eae;
            }
            SelectionBroker.this.setForceQueueing(false);
            SelectionBroker.this.triggerProcessQueuedSelectionChanges();
        }

        public void doRedoAction() throws ExtendedActionException {
            SelectionBroker.this.setForceQueueing(true);
            try {
                super.doRedoAction();
            }
            catch (ExtendedActionException eae) {
                SelectionBroker.this.setForceQueueing(false);
                SelectionBroker.this.triggerProcessQueuedSelectionChanges();
                throw eae;
            }
            SelectionBroker.this.setForceQueueing(false);
            SelectionBroker.this.triggerProcessQueuedSelectionChanges();
        }
    }

    private class QueuedReplaceInSelection
    extends AQueuedSelectionChange {
        private final Selection fSelectablesToReplace;
        private final Selection fReplacingSelectables;

        public QueuedReplaceInSelection(Object source, Selection selectablesToReplace, Selection replacingSelectables, ISelectionChangeInitiator selectionChangeInitiator) {
            super(source, selectionChangeInitiator);
            this.fSelectablesToReplace = selectablesToReplace;
            this.fReplacingSelectables = replacingSelectables;
        }

        public Selection getResultingSelection(Selection currentSelection) {
            Set topLevelSectablesToReplace = this.fSelectablesToReplace.getTopLevelSelectables();
            SelectionFactory selectionFactory = new SelectionFactory();
            SelectionEnumeration currentSelectionEnumeration = currentSelection.selectionEnumeration();
            SelectionEnumeration replacingSelectablesEnumeration = this.fReplacingSelectables.selectionEnumeration();
            while (currentSelectionEnumeration.hasMoreElements()) {
                ASelectable candidateSelectable = currentSelectionEnumeration.nextSelectable();
                if (topLevelSectablesToReplace.contains(candidateSelectable)) continue;
                selectionFactory.addTopLevelSelectable(candidateSelectable);
            }
            while (replacingSelectablesEnumeration.hasMoreElements()) {
                selectionFactory.addTopLevelSelectable(replacingSelectablesEnumeration.nextSelectable());
            }
            return selectionFactory.createSelection();
        }
    }

    private class QueuedMergeSelection
    extends AQueuedSelectionChange {
        private final Selection fSelectionToMerge;
        private final boolean fReplaceTopLevelSelectablesOfSameType;

        public QueuedMergeSelection(Object source, Selection selectionToMerge, boolean replaceTopLevelSelectablesOfSameType, ISelectionChangeInitiator selectionChangeInitiator) {
            super(source, selectionChangeInitiator);
            this.fSelectionToMerge = selectionToMerge;
            this.fReplaceTopLevelSelectablesOfSameType = replaceTopLevelSelectablesOfSameType;
        }

        public Selection getResultingSelection(Selection currentSelection) {
            SelectionFactory selectionFactory = new SelectionFactory();
            SelectionEnumeration currentSelectionEnumeration = currentSelection.selectionEnumeration();
            SelectionEnumeration selectionToMergeEnumeration = this.fSelectionToMerge.selectionEnumeration();
            while (selectionToMergeEnumeration.hasMoreElements()) {
                selectionFactory.addTopLevelSelectable(selectionToMergeEnumeration.nextSelectable());
            }
            while (currentSelectionEnumeration.hasMoreElements()) {
                ASelectable aSelectable = currentSelectionEnumeration.nextSelectable();
                if (this.fReplaceTopLevelSelectablesOfSameType && this.fSelectionToMerge.hasSelectableOfType(aSelectable.getSelectableType(), false)) continue;
                selectionFactory.addTopLevelSelectable(aSelectable);
            }
            return selectionFactory.createSelection();
        }
    }

    private abstract class AQueuedSelectionChange {
        private final Object fSource;
        private final ISelectionChangeInitiator fSelectionChangeInitiator;

        protected AQueuedSelectionChange(Object source, ISelectionChangeInitiator selectionChangeInitiator) {
            this.fSource = source;
            this.fSelectionChangeInitiator = selectionChangeInitiator;
        }

        public abstract Selection getResultingSelection(Selection var1);

        public Object getSource() {
            return this.fSource;
        }

        public ISelectionChangeInitiator getSelectionChangeInitiator() {
            return this.fSelectionChangeInitiator;
        }
    }
}

