/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import com.wily.wilyassert.Assertion;
import com.wily.wilyassert.SwingAssertion;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SynchronizedTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 4546051809439223469L;

    public SynchronizedTreeModel(TreeNode root) {
        super(root);
    }

    public SynchronizedTreeModel(TreeNode root, boolean asksAllowsChildren) {
        super(root, asksAllowsChildren);
    }

    public void setAsksAllowsChildren(boolean newValue) {
        super.setAsksAllowsChildren(newValue);
    }

    public void setAsksAllowsChildrenAsync(final boolean newValue) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SynchronizedTreeModel.this.setAsksAllowsChildren(newValue);
            }
        });
    }

    public void setAsksAllowsChildrenSync(boolean newValue) {
        this.setAsksAllowsChildren(newValue);
    }

    public boolean asksAllowsChildren() {
        return super.asksAllowsChildren();
    }

    public boolean asksAllowsChildrenAsync() throws InvocationTargetException, InterruptedException {
        final boolean[] result = new boolean[1];
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                result[0] = SynchronizedTreeModel.this.asksAllowsChildren();
            }
        });
        return result[0];
    }

    public boolean asksAllowsChildrenSync() {
        return this.asksAllowsChildren();
    }

    public void setRoot(TreeNode root) {
        SwingAssertion.assertSwingSafe();
        super.setRoot(root);
    }

    public void setRootAsync(final TreeNode root) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SynchronizedTreeModel.this.setRoot(root);
            }
        });
    }

    public void setRootSync(TreeNode root) {
        this.setRoot(root);
    }

    public Object getRoot() {
        return super.getRoot();
    }

    public Object getRootAsync() throws InvocationTargetException, InterruptedException {
        final Object[] result = new Object[1];
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                result[0] = SynchronizedTreeModel.this.getRoot();
            }
        });
        return result[0];
    }

    public Object getRootSync() {
        return this.getRoot();
    }

    public int getIndexOfChild(Object parent, Object child) {
        return super.getIndexOfChild(parent, child);
    }

    public int getIndexOfChildAsync(final Object parent, final Object child) throws InvocationTargetException, InterruptedException {
        final int[] result = new int[1];
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                result[0] = SynchronizedTreeModel.this.getIndexOfChild(parent, child);
            }
        });
        return result[0];
    }

    public int getIndexOfChildSync(Object parent, Object child) {
        return this.getIndexOfChild(parent, child);
    }

    public Object getChild(Object parent, int index) {
        return super.getChild(parent, index);
    }

    public Object getChildAsync(final Object parent, final int index) throws InvocationTargetException, InterruptedException {
        final Object[] result = new Object[1];
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                result[0] = SynchronizedTreeModel.this.getChild(parent, index);
            }
        });
        return result[0];
    }

    public Object getChildSync(Object parent, int index) {
        return this.getChild(parent, index);
    }

    public int getChildCount(Object parent) {
        return super.getChildCount(parent);
    }

    public int getChildCountAsync(final Object parent) throws InvocationTargetException, InterruptedException {
        final int[] result = new int[1];
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                result[0] = SynchronizedTreeModel.this.getChildCount(parent);
            }
        });
        return result[0];
    }

    public int getChildCountSync(Object parent) {
        return this.getChildCount(parent);
    }

    public boolean isLeaf(Object node) {
        return super.isLeaf(node);
    }

    public boolean isLeafAsync(final Object node) throws InvocationTargetException, InterruptedException {
        final boolean[] result = new boolean[1];
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                result[0] = SynchronizedTreeModel.this.isLeaf(node);
            }
        });
        return result[0];
    }

    public boolean isLeafSync(Object node) {
        return this.isLeaf(node);
    }

    public void reload() {
        SwingAssertion.assertSwingSafe();
        super.reload();
    }

    public void reloadAsync() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SynchronizedTreeModel.this.reload();
            }
        });
    }

    public void reloadSync() {
        this.reload();
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        SwingAssertion.assertSwingSafe();
        super.valueForPathChanged(path, newValue);
    }

    public void valueForPathChangedAsync(final TreePath path, final Object newValue) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SynchronizedTreeModel.this.valueForPathChanged(path, newValue);
            }
        });
    }

    public void valueForPathChangedSync(TreePath path, Object newValue) {
        this.valueForPathChanged(path, newValue);
    }

    public void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
        SwingAssertion.assertSwingSafe();
        super.insertNodeInto(newChild, parent, index);
    }

    public void insertNodeIntoAsync(final MutableTreeNode newChild, final MutableTreeNode parent, final int index) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SynchronizedTreeModel.this.insertNodeInto(newChild, parent, index);
            }
        });
    }

    public void insertNodeIntoSync(MutableTreeNode newChild, MutableTreeNode parent, int index) {
        this.insertNodeInto(newChild, parent, index);
    }

    public void removeNodeFromParent(MutableTreeNode node) {
        SwingAssertion.assertSwingSafe();
        super.removeNodeFromParent(node);
    }

    public void removeNodeFromParentAsync(final MutableTreeNode node) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SynchronizedTreeModel.this.removeNodeFromParent(node);
            }
        });
    }

    public void removeNodeFromParentSync(MutableTreeNode node) {
        this.removeNodeFromParent(node);
    }

    public void nodeChanged(TreeNode node) {
        SwingAssertion.assertSwingSafe();
        super.nodeChanged(node);
    }

    public void nodeChangedAsync(final TreeNode node) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SynchronizedTreeModel.this.nodeChanged(node);
            }
        });
    }

    public void nodeChangedSync(TreeNode node) {
        this.nodeChanged(node);
    }

    public void reload(TreeNode node) {
        SwingAssertion.assertSwingSafe();
        super.reload(node);
    }

    public void reloadAsync(final TreeNode node) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SynchronizedTreeModel.this.reload(node);
            }
        });
    }

    public void reloadSync(TreeNode node) {
        this.reload(node);
    }

    public void nodesWereInserted(TreeNode node, int[] childIndices) {
        SwingAssertion.assertSwingSafe();
        super.nodesWereInserted(node, childIndices);
    }

    public void nodesWereInsertedAsync(final TreeNode node, final int[] childIndices) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SynchronizedTreeModel.this.nodesWereInserted(node, childIndices);
            }
        });
    }

    public void nodesWereInsertedSync(TreeNode node, int[] childIndices) {
        this.nodesWereInserted(node, childIndices);
    }

    public void nodesWereRemoved(TreeNode node, int[] childIndices, Object[] removedChildren) {
        SwingAssertion.assertSwingSafe();
        super.nodesWereRemoved(node, childIndices, removedChildren);
    }

    public void nodesWereRemovedAsync(final TreeNode node, final int[] childIndices, final Object[] removedChildren) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SynchronizedTreeModel.this.nodesWereRemoved(node, childIndices, removedChildren);
            }
        });
    }

    public void nodesWereRemovedSync(TreeNode node, int[] childIndices, Object[] removedChildren) {
        this.nodesWereRemoved(node, childIndices, removedChildren);
    }

    public void nodesChanged(TreeNode node, int[] childIndices) {
        SwingAssertion.assertSwingSafe();
        super.nodesChanged(node, childIndices);
    }

    public void nodesChangedAsync(final TreeNode node, final int[] childIndices) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SynchronizedTreeModel.this.nodesChanged(node, childIndices);
            }
        });
    }

    public void nodesChangedSync(TreeNode node, int[] childIndices) {
        this.nodesChanged(node, childIndices);
    }

    public void nodeStructureChanged(TreeNode node) {
        SwingAssertion.assertSwingSafe();
        super.nodeStructureChanged(node);
    }

    public void nodeStructureChangedAsync(final TreeNode node) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SynchronizedTreeModel.this.nodeStructureChanged(node);
            }
        });
    }

    public void nodeStructureChangedSync(TreeNode node) {
        this.nodeStructureChanged(node);
    }

    public TreeNode[] getPathToRoot(TreeNode aNode) {
        return super.getPathToRoot(aNode);
    }

    public TreeNode[] getPathToRootAsync(final TreeNode aNode) throws InvocationTargetException, InterruptedException {
        final TreeNode[][] result = new TreeNode[1][];
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                result[0] = SynchronizedTreeModel.this.getPathToRoot(aNode);
            }
        });
        return result[0];
    }

    public TreeNode[] getPathToRootSync(TreeNode aNode) {
        return this.getPathToRoot(aNode);
    }

    protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
        return super.getPathToRoot(aNode, depth);
    }

    protected TreeNode[] getPathToRootAsync(final TreeNode aNode, final int depth) throws InvocationTargetException, InterruptedException {
        final TreeNode[][] result = new TreeNode[1][];
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                result[0] = SynchronizedTreeModel.this.getPathToRoot(aNode, depth);
            }
        });
        return result[0];
    }

    protected TreeNode[] getPathToRootSync(TreeNode aNode, int depth) {
        return this.getPathToRoot(aNode, depth);
    }

    public void addTreeModelListener(TreeModelListener l) {
        super.addTreeModelListener(l);
    }

    public void addTreeModelListenerAsync(final TreeModelListener l) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SynchronizedTreeModel.this.addTreeModelListener(l);
            }
        });
    }

    public void addTreeModelListenerSync(TreeModelListener l) {
        this.addTreeModelListener(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        super.removeTreeModelListener(l);
    }

    public void removeTreeModelListenerAsync(final TreeModelListener l) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SynchronizedTreeModel.this.removeTreeModelListener(l);
            }
        });
    }

    public void removeTreeModelListenerSync(TreeModelListener l) {
        this.removeTreeModelListener(l);
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        SwingAssertion.assertSwingSafe();
        super.fireTreeNodesChanged(source, path, childIndices, children);
    }

    protected void fireTreeNodesChangedAsync(final Object source, final Object[] path, final int[] childIndices, final Object[] children) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SynchronizedTreeModel.this.fireTreeNodesChanged(source, path, childIndices, children);
            }
        });
    }

    protected void fireTreeNodesChangedSync(Object source, Object[] path, int[] childIndices, Object[] children) {
        this.fireTreeNodesChanged(source, path, childIndices, children);
    }

    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        SwingAssertion.assertSwingSafe();
        super.fireTreeNodesInserted(source, path, childIndices, children);
    }

    protected void fireTreeNodesInsertedAsync(final Object source, final Object[] path, final int[] childIndices, final Object[] children) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SynchronizedTreeModel.this.fireTreeNodesInserted(source, path, childIndices, children);
            }
        });
    }

    protected void fireTreeNodesInsertedSync(Object source, Object[] path, int[] childIndices, Object[] children) {
        this.fireTreeNodesInserted(source, path, childIndices, children);
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        SwingAssertion.assertSwingSafe();
        super.fireTreeNodesRemoved(source, path, childIndices, children);
    }

    protected void fireTreeNodesRemovedAsync(final Object source, final Object[] path, final int[] childIndices, final Object[] children) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SynchronizedTreeModel.this.fireTreeNodesRemoved(source, path, childIndices, children);
            }
        });
    }

    protected void fireTreeNodesRemovedSync(Object source, Object[] path, int[] childIndices, Object[] children) {
        this.fireTreeNodesRemoved(source, path, childIndices, children);
    }

    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        SwingAssertion.assertSwingSafe();
        super.fireTreeStructureChanged(source, path, childIndices, children);
    }

    protected void fireTreeStructureChangedAsync(final Object source, final Object[] path, final int[] childIndices, final Object[] children) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SynchronizedTreeModel.this.fireTreeStructureChanged(source, path, childIndices, children);
            }
        });
    }

    protected void fireTreeStructureChangedSync(Object source, Object[] path, int[] childIndices, Object[] children) {
        this.fireTreeStructureChanged(source, path, childIndices, children);
    }

    public void sortedInsertNodeIntoAsync(final Comparator comparator, final DefaultMutableTreeNode newChild, final DefaultMutableTreeNode parent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SynchronizedTreeModel.this.sortedInsertNodeIntoSync(comparator, newChild, parent);
            }
        });
    }

    public void sortedInsertNodeIntoSync(Comparator comparator, DefaultMutableTreeNode newChild, DefaultMutableTreeNode parent) {
        int insertionIndex = this.getSortedInsertionIndexForNewChild(comparator, newChild, parent);
        this.insertNodeIntoSync(newChild, parent, insertionIndex);
    }

    private int getSortedInsertionIndexForNewChild(Comparator comparator, DefaultMutableTreeNode newChild, DefaultMutableTreeNode parent) {
        SwingAssertion.assertSwingSafe();
        int numChildren = parent.getChildCount();
        int insertionIndex = 0;
        if (numChildren == 0) {
            insertionIndex = 0;
        } else {
            int low = 0;
            int high = numChildren - 1;
            while (low <= high) {
                int mid = (low + high) / 2;
                DefaultMutableTreeNode midVal = (DefaultMutableTreeNode)parent.getChildAt(mid);
                int compare = comparator.compare(newChild.getUserObject(), midVal.getUserObject());
                if (compare > 0) {
                    low = mid + 1;
                    continue;
                }
                if (compare < 0) {
                    high = mid - 1;
                    continue;
                }
                Assertion.wilyAssert(false, "Shouldn't be able to find a new child already there");
            }
            insertionIndex = low;
            Assertion.wilyAssert(insertionIndex <= parent.getChildCount());
        }
        return insertionIndex;
    }

    public void sortedAddChildNodeWithoutFiringTreeModelEventSync(Comparator comparator, DefaultMutableTreeNode newChild, DefaultMutableTreeNode parent) {
        int insertionIndex = this.getSortedInsertionIndexForNewChild(comparator, newChild, parent);
        parent.insert(newChild, insertionIndex);
    }
}

