/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.extension;

import com.wily.util.StringUtils;
import com.wily.util.extension.IExtension;
import com.wily.util.extension.IExtensionProxy;
import com.wily.util.extension.InvalidExtensionException;
import com.wily.util.extension.JarExtension;
import com.wily.util.extension.JarURLPhysicalModule;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.ExtendedFile;
import com.wily.util.text.FormattedLocalizableMessage;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.jar.Attributes;

public class JarExtensionProxy
implements IExtensionProxy {
    private final ExtendedFile fTargetFile;
    private final JarURLPhysicalModule fJarModule;
    private final String fName;
    private final List fDependencies;
    private final String fType;
    private int fRank;

    public JarExtensionProxy(ExtendedFile targetFile) throws InvalidExtensionException {
        this.fTargetFile = targetFile;
        try {
            this.fJarModule = new JarURLPhysicalModule(this.fTargetFile.toURL());
        }
        catch (IOException e) {
            throw new InvalidExtensionException("Invalid jar file", e, new FormattedLocalizableMessage("Extension_Invalid_Jar_File_Message", new String[]{this.fTargetFile.getAbsolutePath()}));
        }
        this.fName = this.getMainAttributeValueorThrow("com-wily-Extension-Name");
        String commaSeparatedDependencies = this.getMainAttributeValue("com-wily-Extension-depends-on");
        String[] deps = commaSeparatedDependencies == null ? new String[]{} : StringUtils.parseAndTrimList(commaSeparatedDependencies, ",");
        this.fDependencies = Arrays.asList(deps);
        this.fType = this.getMainAttributeValue("com-wily-Extension-Type");
    }

    public String IExtensionProxy_getName() {
        return this.fName;
    }

    public String[] IExtensionProxy_getDependencies() {
        return (String[])this.fDependencies.toArray();
    }

    public String IExtensionProxy_getType() {
        return this.fType;
    }

    public IExtension IExtensionProxy_newInstance(IModuleFeedbackChannel feedback, ClassLoader parentClassLoader) throws InvalidExtensionException {
        JarExtension extension = new JarExtension(this.fName, this.IExtensionProxy_getDependencies(), feedback, this.fTargetFile);
        extension.IExtension_setParentClassLoader(parentClassLoader);
        return extension;
    }

    Attributes getMainAttributes() {
        return this.fJarModule.getManifest().getMainAttributes();
    }

    private String getMainAttributeValueorThrow(String key) throws InvalidExtensionException {
        String value = this.getMainAttributes().getValue(key);
        if (value == null) {
            throw new InvalidExtensionException(new FormattedLocalizableMessage("Extension_Missing_Required_Manifest_Attribute_Message", new String[]{this.fName, this.fTargetFile.getAbsolutePath(), key}));
        }
        return value;
    }

    private String getMainAttributeValue(String key) {
        String value = this.getMainAttributes().getValue(key);
        return value;
    }

    public boolean equals(Object obj) {
        JarExtensionProxy other = (JarExtensionProxy)obj;
        return other.IExtensionProxy_getName().equals(this.fName);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Jar File Extension -");
        sb.append(this.fName);
        sb.append("Located at -" + this.fTargetFile.getAbsolutePath());
        return sb.toString();
    }

    public int hashCode() {
        return this.fName.hashCode();
    }

    public String ITopologicalSortNode_getId() {
        return this.IExtensionProxy_getName();
    }

    public String[] ITopologicalSort_getDependencies() {
        return this.IExtensionProxy_getDependencies();
    }

    public int ITopologicalSort_getRank() {
        return this.fRank;
    }

    public void ITopologicalSort_setRank(int v) {
        this.fRank = v;
    }
}

