/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.pool;

import com.wily.util.pool.IPoolable;
import com.wily.wilyassert.Assertion;

public final class FixedSizeObjectPool {
    private final IPoolable[] fElements;
    private final Class fPooledClass;
    private int fCount;

    public FixedSizeObjectPool(Class pooledClass, int size) {
        Assertion.wilyAssert(pooledClass != null);
        Assertion.wilyAssert(IPoolable.class.isAssignableFrom(pooledClass));
        Assertion.wilyAssert(size >= 1);
        if (size < 0) {
            size = 0;
        }
        this.fElements = new IPoolable[size];
        this.fPooledClass = pooledClass;
        this.fCount = 0;
    }

    public synchronized IPoolable getPooledObject() {
        IPoolable result = null;
        if (this.fCount > 0) {
            result = this.fElements[--this.fCount];
            this.fElements[this.fCount] = null;
        } else {
            try {
                result = (IPoolable)this.fPooledClass.newInstance();
            }
            catch (IllegalAccessException iae) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        Assertion.wilyAssert(result != null);
        return result;
    }

    public synchronized void returnPooledObject(IPoolable poolable) {
        Assertion.wilyAssert(poolable != null && poolable.getClass() == this.fPooledClass);
        if (this.fCount < this.fElements.length) {
            this.fElements[this.fCount++] = poolable;
            poolable.IPoolable_returnedToPool();
        }
    }

    public synchronized void clear() {
        while (this.fCount > 0) {
            this.fElements[--this.fCount] = null;
        }
    }
}

