/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.xmlserialization;

import com.wily.util.xmlserialization.ICustomXmlizable;
import com.wily.util.xmlserialization.IXmlReferenceable;
import com.wily.util.xmlserialization.IXmlWriter;
import com.wily.util.xmlserialization.IXmlizable;
import com.wily.util.xmlserialization.XmlException;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Stack;

public class XmlWriter
implements IXmlWriter {
    private Writer writer;
    private Stack stack;
    private StringBuffer attrs;
    private boolean empty;
    private boolean closed;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$com$wily$util$xmlserialization$IXmlReferenceable;
    static /* synthetic */ Class class$com$wily$util$xmlserialization$IXmlizable;

    public XmlWriter(Writer writer) {
        this.writer = writer;
        this.closed = true;
        this.stack = new Stack();
    }

    public void startElement(String name) throws XmlException {
        try {
            this.closeOpeningTag();
            this.closed = false;
            this.writer.write("<");
            this.writer.write(name);
            this.stack.add(name);
            this.empty = true;
        }
        catch (IOException ioe) {
            throw new XmlException(ioe);
        }
    }

    public void writeElement(String name, IXmlizable element) throws XmlException {
        this.startElement(name);
        this.writeElement(element);
        this.endElement();
    }

    public void writeElement(IXmlizable element) throws XmlException {
        if (element == null) {
            this.writeText("NULL");
        } else if (element instanceof ICustomXmlizable) {
            ((ICustomXmlizable)element).writeXML(this);
        } else {
            this.writeJavaObjectByReflection(element);
        }
    }

    private void writeJavaObjectByReflection(Object obj) throws XmlException {
        try {
            this.startElement("Object");
            this.writeAttribute("Type", obj.getClass().getName());
            if (obj instanceof IXmlReferenceable) {
                this.writeAttribute("UID", ((IXmlReferenceable)obj).getXmlReferenceUID());
            }
            Class<?> currentClass = obj.getClass();
            while (!currentClass.equals(class$java$lang$Object == null ? XmlWriter.class$("java.lang.Object") : class$java$lang$Object)) {
                Field[] fields = currentClass.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    int j;
                    int arrLen;
                    Field f = fields[i];
                    if (Modifier.isTransient(f.getModifiers()) || Modifier.isStatic(f.getModifiers())) continue;
                    f.setAccessible(true);
                    this.startElement("Field");
                    Class<?> type = f.getType();
                    this.writeAttribute("Name", this.stripFieldNamePrefix(f.getName()));
                    this.writeAttribute("Type", type.getName());
                    this.startElement("Value");
                    if (type.isPrimitive() || type.isAssignableFrom(class$java$lang$Number == null ? XmlWriter.class$("java.lang.Number") : class$java$lang$Number) || type.equals(class$java$lang$String == null ? XmlWriter.class$("java.lang.String") : class$java$lang$String)) {
                        Object val = f.get(obj);
                        this.writeText(val == null ? "NULL" : val.toString());
                    } else if (type.isArray()) {
                        Object arr = f.get(obj);
                        if (arr == null) {
                            this.writeText("NULL");
                        } else {
                            this.startElement("Array");
                            arrLen = Array.getLength(arr);
                            this.writeAttribute("Length", arrLen);
                            for (j = 0; j < arrLen; ++j) {
                                this.writeJavaObjectByReflection(Array.get(arr, j));
                            }
                            this.endElement();
                        }
                    } else if ((class$java$util$List == null ? XmlWriter.class$("java.util.List") : class$java$util$List).isAssignableFrom(type)) {
                        List list = (List)f.get(obj);
                        if (list == null) {
                            this.writeText("NULL");
                        } else {
                            this.startElement("List");
                            arrLen = list.size();
                            this.writeAttribute("Length", arrLen);
                            for (j = 0; j < arrLen; ++j) {
                                this.writeJavaObjectByReflection(list.get(j));
                            }
                            this.endElement();
                        }
                    } else if ((class$com$wily$util$xmlserialization$IXmlReferenceable == null ? XmlWriter.class$("com.wily.util.xmlserialization.IXmlReferenceable") : class$com$wily$util$xmlserialization$IXmlReferenceable).isAssignableFrom(type)) {
                        this.writeElementReference((IXmlReferenceable)f.get(obj));
                    } else if ((class$com$wily$util$xmlserialization$IXmlizable == null ? XmlWriter.class$("com.wily.util.xmlserialization.IXmlizable") : class$com$wily$util$xmlserialization$IXmlizable).isAssignableFrom(type)) {
                        this.writeElement((IXmlizable)f.get(obj));
                    } else {
                        throw new XmlException("Type " + type.getName() + " is not supported by XMLWriter. Either the declaring Class " + obj.getClass().getName() + " must implement ICustomXmlizable interface, or the Field " + f.getName() + " must implement IXmlizable interface.");
                    }
                    this.endElement();
                    this.endElement();
                }
                currentClass = currentClass.getSuperclass();
            }
            this.endElement();
        }
        catch (IllegalAccessException e) {
            throw new XmlException(e);
        }
    }

    private String stripFieldNamePrefix(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("f")) {
            return name.substring("f".length());
        }
        return null;
    }

    public void writeElementReference(String name, IXmlReferenceable element) throws XmlException {
        this.startElement(name);
        this.writeElementReference(element);
        this.endElement();
    }

    public void writeElementReference(IXmlReferenceable element) throws XmlException {
        if (element == null) {
            this.writeText("NULL");
        } else {
            this.startElement("Reference");
            this.writeAttribute("TargetType", element.getClass().getName());
            this.writeAttribute("TargetUID", element.getXmlReferenceUID());
            this.endElement();
        }
    }

    public void writeAttribute(String attr, String value) throws XmlException {
        if (this.attrs == null) {
            this.attrs = new StringBuffer();
        }
        this.attrs.append(" ");
        this.attrs.append(attr);
        this.attrs.append("=\"");
        this.attrs.append(XmlWriter.escapeXml(value));
        this.attrs.append("\"");
    }

    public void writeAttribute(String attr, long value) throws XmlException {
        this.writeAttribute(attr, Long.toString(value));
    }

    public void writeAttribute(String attr, int value) throws XmlException {
        this.writeAttribute(attr, Integer.toString(value));
    }

    public void writeAttribute(String attr, short value) throws XmlException {
        this.writeAttribute(attr, Short.toString(value));
    }

    public void writeAttribute(String attr, byte value) throws XmlException {
        this.writeAttribute(attr, Byte.toString(value));
    }

    public void writeAttribute(String attr, boolean value) throws XmlException {
        this.writeAttribute(attr, Boolean.toString(value));
    }

    public void writeAttribute(String attr, float value) throws XmlException {
        this.writeAttribute(attr, Float.toString(value));
    }

    public void writeAttribute(String attr, double value) throws XmlException {
        this.writeAttribute(attr, Double.toString(value));
    }

    public void endElement() throws XmlException {
        try {
            if (this.stack.empty()) {
                throw new XmlException("Called endElement too many times. ");
            }
            String name = (String)this.stack.pop();
            if (name != null) {
                if (this.empty) {
                    this.writeAttributes();
                    this.writer.write("/>");
                } else {
                    this.writer.write("</");
                    this.writer.write(name);
                    this.writer.write(">");
                }
                this.empty = false;
                this.closed = true;
            }
        }
        catch (IOException ioe) {
            throw new XmlException(ioe);
        }
    }

    public void writeText(String text) throws XmlException {
        try {
            this.closeOpeningTag();
            this.empty = false;
            this.writer.write(XmlWriter.escapeXml(text));
        }
        catch (IOException ioe) {
            throw new XmlException(ioe);
        }
    }

    public void close() throws XmlException {
        if (!this.stack.empty()) {
            throw new XmlException("Tags are not all closed. Possibly, " + this.stack.pop() + " is unclosed. ");
        }
    }

    private void closeOpeningTag() throws IOException {
        if (!this.closed) {
            this.writeAttributes();
            this.closed = true;
            this.writer.write(">");
        }
    }

    private void writeAttributes() throws IOException {
        if (this.attrs != null) {
            this.writer.write(this.attrs.toString());
            this.attrs.setLength(0);
            this.empty = false;
        }
    }

    private static String escapeXml(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer(s.length());
        char[] chars = s.toCharArray();
        block7: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '&': {
                    buff.append("&amp;");
                    continue block7;
                }
                case '<': {
                    buff.append("&lt;");
                    continue block7;
                }
                case '>': {
                    buff.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    buff.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    buff.append("&apos;");
                    continue block7;
                }
                default: {
                    buff.append(chars[i]);
                }
            }
        }
        return buff.toString();
    }
}

