/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.feedback;

import com.wily.org.apache.log4j.Level;
import com.wily.util.feedback.SeverityLevel;
import com.wily.wilyassert.Assertion;

public class Log4JSeverityLevel
extends Level {
    private final SeverityLevel fWilySeverityLevel;
    public static final int VERBOSE_INT = 19990;
    public static final int TRACE_INT = 9990;
    public static final Log4JSeverityLevel OFF = new Log4JSeverityLevel(SeverityLevel.OFF, Integer.MAX_VALUE, "OFF", 0);
    public static final Log4JSeverityLevel FATAL = new Log4JSeverityLevel(SeverityLevel.FATAL, 50000, "FATAL", 0);
    public static final Log4JSeverityLevel ERROR = new Log4JSeverityLevel(SeverityLevel.ERROR, 40000, "ERROR", 3);
    public static final Log4JSeverityLevel WARN = new Log4JSeverityLevel(SeverityLevel.WARN, 30000, "WARN", 4);
    public static final Log4JSeverityLevel INFO = new Log4JSeverityLevel(SeverityLevel.INFO, 20000, "INFO", 6);
    public static final Log4JSeverityLevel VERBOSE = new Log4JSeverityLevel(SeverityLevel.VERBOSE, 19990, "VERBOSE", 7);
    public static final Log4JSeverityLevel DEBUG = new Log4JSeverityLevel(SeverityLevel.DEBUG, 10000, "DEBUG", 8);
    public static final Log4JSeverityLevel TRACE = new Log4JSeverityLevel(SeverityLevel.TRACE, 9990, "TRACE", 9);
    public static final Log4JSeverityLevel ALL = new Log4JSeverityLevel(SeverityLevel.ALL, Integer.MIN_VALUE, "ALL", 10);

    protected Log4JSeverityLevel(SeverityLevel wilyLevel, int level, String levelStr, int syslogEquivalent) {
        super(level, levelStr, syslogEquivalent);
        this.fWilySeverityLevel = wilyLevel;
    }

    public SeverityLevel getSeverityLevel() {
        return this.fWilySeverityLevel;
    }

    /*
     * WARNING - void declaration
     */
    public static Level toLevel(int val, Level defaultLevel) {
        void var2_2;
        switch (val) {
            case -2147483648: {
                Log4JSeverityLevel sl = ALL;
                break;
            }
            case 9990: {
                Log4JSeverityLevel sl = TRACE;
                break;
            }
            case 10000: {
                Log4JSeverityLevel sl = DEBUG;
                break;
            }
            case 19990: {
                Log4JSeverityLevel sl = VERBOSE;
                break;
            }
            case 20000: {
                Log4JSeverityLevel sl = INFO;
                break;
            }
            case 30000: {
                Log4JSeverityLevel sl = WARN;
                break;
            }
            case 40000: {
                Log4JSeverityLevel sl = ERROR;
                break;
            }
            case 50000: {
                Log4JSeverityLevel sl = FATAL;
                break;
            }
            case 0x7FFFFFFF: {
                Log4JSeverityLevel sl = OFF;
                break;
            }
            default: {
                return defaultLevel;
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Level toLevel(String sArg, Level defaultLevel) {
        void var3_3;
        Log4JSeverityLevel sl;
        if (sArg == null) {
            return defaultLevel;
        }
        String s = sArg.toUpperCase();
        if (s.equals("ALL")) {
            sl = ALL;
        } else if (s.equals("TRACE")) {
            sl = TRACE;
        } else if (s.equals("DEBUG")) {
            sl = DEBUG;
        } else if (s.equals("VERBOSE")) {
            sl = VERBOSE;
        } else if (s.equals("INFO")) {
            sl = INFO;
        } else if (s.equals("WARN")) {
            sl = WARN;
        } else if (s.equals("ERROR")) {
            sl = ERROR;
        } else if (s.equals("FATAL")) {
            sl = FATAL;
        } else if (s.equals("OFF")) {
            sl = OFF;
        } else {
            return defaultLevel;
        }
        return var3_3;
    }

    public static Log4JSeverityLevel getLog4JSeverityLevel(SeverityLevel severityLevel) {
        Log4JSeverityLevel result = ALL;
        if (severityLevel == SeverityLevel.ERROR) {
            result = ERROR;
        } else if (severityLevel == SeverityLevel.WARN) {
            result = WARN;
        } else if (severityLevel == SeverityLevel.INFO) {
            result = INFO;
        } else if (severityLevel == SeverityLevel.VERBOSE) {
            result = VERBOSE;
        } else if (severityLevel == SeverityLevel.DEBUG) {
            result = DEBUG;
        } else if (severityLevel == SeverityLevel.TRACE) {
            result = TRACE;
        } else {
            Assertion.wilyFail("Unknown SeverityLevel: " + severityLevel);
        }
        return result;
    }

    public static SeverityLevel getSeverityLevelFromLog4J(Level level) {
        SeverityLevel result = null;
        if (level == ERROR) {
            result = SeverityLevel.ERROR;
        } else if (level == WARN) {
            result = SeverityLevel.WARN;
        } else if (level == INFO) {
            result = SeverityLevel.INFO;
        } else if (level == VERBOSE) {
            result = SeverityLevel.VERBOSE;
        } else if (level == DEBUG) {
            result = SeverityLevel.DEBUG;
        } else if (level == TRACE) {
            result = SeverityLevel.TRACE;
        } else if (level == ALL) {
            result = SeverityLevel.ALL;
        } else if (level == OFF) {
            result = SeverityLevel.OFF;
        } else {
            if (level == null) {
                return null;
            }
            Assertion.wilyFail("Unknown SeverityLevel: " + level);
        }
        return result;
    }
}

