/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.spec;

import com.wily.rave.spec.IContent;
import com.wily.rave.spec.IContentChange;
import com.wily.rave.spec.IContentMetadataItem;
import com.wily.rave.spec.IContentSummary;
import com.wily.rave.spec.IContentValue;
import com.wily.rave.spec.IDataSourceInstance;
import com.wily.rave.spec.InvalidContent;
import com.wily.rave.spec.PropertyContentChange;
import com.wily.rave.spec.PropertyValue;
import com.wily.rave.utils.HashCodeUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;

public class PropertyContent
implements IContent,
IContentSummary,
Externalizable {
    private static final long serialVersionUID = 1L;
    private String fPropertyName;
    private IContentValue fPropertyValue;
    private IDataSourceInstance fDataSourceInstance;
    static /* synthetic */ Class class$0;

    public PropertyContent() {
    }

    public PropertyContent(IDataSourceInstance dsInstance, String propertyName, String propertyValue) {
        this.fDataSourceInstance = dsInstance;
        this.fPropertyName = propertyName;
        this.fPropertyValue = new PropertyValue(propertyValue);
    }

    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeUTF(this.fPropertyName);
        oo.writeLong(1L);
        oo.writeObject(this.fPropertyValue);
        oo.writeObject(this.fDataSourceInstance);
    }

    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        this.fPropertyName = oi.readUTF();
        long oiLong = oi.readLong();
        Long object = new Long(oiLong);
        if (object instanceof Long) {
            long serialUID = object;
            if (serialUID != 1L) {
                throw new ClassNotFoundException("Unknown serialVersionUID for PropertyContent: " + serialUID);
            }
            this.fPropertyValue = (IContentValue)oi.readObject();
        } else if (object instanceof IContentValue) {
            this.fPropertyValue = (IContentValue)((Object)object);
        }
        this.fDataSourceInstance = (IDataSourceInstance)oi.readObject();
    }

    public long getChangeTimestamp() {
        return -1L;
    }

    public String getResourceName() {
        return this.fPropertyName;
    }

    public String getResourceOwner() {
        return null;
    }

    public IContentValue getResourceValue() {
        return this.fPropertyValue;
    }

    public IDataSourceInstance getDataSourceInstance() {
        return this.fDataSourceInstance;
    }

    public IContentChange getChange(long changeDetectionTime, IContent priorContent) throws InvalidContent {
        if (!(priorContent instanceof PropertyContent)) {
            StringBuffer stringBuffer = new StringBuffer("Not same type content! This: ");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.wily.rave.spec.PropertyContent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new InvalidContent(stringBuffer.append(clazz.getName()).append("; prior content: ").append(priorContent.getClass().getName()).toString());
        }
        PropertyContent priorProperty = (PropertyContent)priorContent;
        return new PropertyContentChange(changeDetectionTime, priorProperty, this);
    }

    public IContentSummary getContentSummary() {
        return this;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof PropertyContent) {
            PropertyContent otherPropertyContent = (PropertyContent)other;
            if (this.fDataSourceInstance.equals(otherPropertyContent.fDataSourceInstance) && this.fPropertyName.equals(otherPropertyContent.fPropertyName) && this.fPropertyValue.equals(otherPropertyContent.fPropertyValue)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int code = HashCodeUtils.accumulateHashCode(this.fDataSourceInstance.hashCode(), this.fPropertyName);
        return code;
    }

    public boolean hasMetadata() {
        return false;
    }

    public IContentMetadataItem[] getMetadata() {
        throw new UnsupportedOperationException();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

