/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.bit;

import com.wily.util.bit.BitPacking;
import com.wily.wilyassert.Assertion;
import java.io.DataOutput;
import java.io.IOException;

public final class CircularBitArray {
    public int[] fBuffer;
    public int fHead;
    public int fTail;
    public int fReadCursor;
    public static final int HunkSize = 16;
    public static final int GrowHunkSize = 4;
    private static final int kMaxElements = 32;
    public static final int ExternalAllocHunk = 16384;
    private static final int kSlop = 2;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wily.util.bit.CircularBitArray");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public CircularBitArray() {
        this.fBuffer = null;
    }

    public CircularBitArray(int size) {
        this.fBuffer = null;
    }

    public CircularBitArray(int[] buffer) {
        this.fBuffer = buffer;
    }

    public final int[] getBuffer() {
        return this.fBuffer;
    }

    public final int getUsedBits() {
        int used = this.fHead - this.fTail;
        if (used < 0) {
            used += this.getBitLength();
        }
        return used;
    }

    public final boolean UnitTestIsBufferNull() {
        return this.fBuffer == null;
    }

    public final int getBitLength() {
        if (this.fBuffer == null) {
            return Integer.MAX_VALUE;
        }
        return this.fBuffer.length << 5;
    }

    public final boolean resetReadCursor() {
        this.fReadCursor = this.fTail;
        return this.fHead != this.fTail;
    }

    public void setTailToReadCursor() {
        if (this.fBuffer == null) {
            this.fHead -= this.fReadCursor;
            this.fReadCursor = 0;
        } else {
            this.fTail = this.fReadCursor;
        }
    }

    private final boolean lazyInit(long value) {
        if (this.fBuffer == null) {
            if (value != 0L) {
                int newInts;
                int n = newInts = this.fHead == 0 ? 1 : (this.fHead - 1 >> 5) + 1;
                if (newInts < 16) {
                    newInts = 16;
                } else {
                    int bitsToNextEvenBoundary = newInts & 3;
                    if (bitsToNextEvenBoundary != 0) {
                        newInts += 4 - bitsToNextEvenBoundary;
                    }
                }
                this.fBuffer = new int[newInts];
                return false;
            }
        } else {
            int bitLength = this.getBitLength();
            if (value != 0L || this.fTail + 93 != this.fHead + (this.fHead < this.fTail ? bitLength : 0)) {
                return false;
            }
            if (this.fTail < this.fHead ? !BitPacking.bitRangeIsZero(this.fBuffer, this.fTail, this.fHead - this.fTail) : !BitPacking.bitRangeIsZero(this.fBuffer, this.fTail, bitLength - this.fTail) || !BitPacking.bitRangeIsZero(this.fBuffer, 0, this.fHead)) {
                return false;
            }
            this.fBuffer = null;
            this.fReadCursor -= this.fTail - (this.fReadCursor < this.fTail ? bitLength : 0);
            this.fHead -= this.fTail - (this.fHead < this.fTail ? bitLength : 0);
            this.fTail = 0;
        }
        return true;
    }

    public void writeLong(int bitLength, long value) {
        if (this.lazyInit(value)) {
            this.fHead += bitLength;
            return;
        }
        this.ensureCapacity(bitLength);
        int maxBitLength = this.getBitLength();
        int newHeadPosition = this.fHead + bitLength;
        if (newHeadPosition <= maxBitLength) {
            BitPacking.writeLong(this.fBuffer, this.fHead, bitLength, value);
            this.fHead += bitLength;
        } else {
            int firstChunkLength = maxBitLength - this.fHead;
            BitPacking.writeLong(this.fBuffer, this.fHead, firstChunkLength, value >> bitLength - firstChunkLength);
            this.fHead = newHeadPosition - maxBitLength;
            BitPacking.writeLong(this.fBuffer, 0, this.fHead, value);
        }
        Assertion.wilyAssert(this.fHead <= maxBitLength);
        if (this.fHead == maxBitLength) {
            this.fHead = 0;
        }
    }

    public void writeInt(int bitLength, int value) {
        if (this.lazyInit(value)) {
            this.fHead += bitLength;
            return;
        }
        this.ensureCapacity(bitLength);
        int maxBitLength = this.getBitLength();
        int newHeadPosition = this.fHead + bitLength;
        if (newHeadPosition <= maxBitLength) {
            BitPacking.writeInt(this.fBuffer, this.fHead, bitLength, value);
            this.fHead += bitLength;
        } else {
            int firstChunkLength = maxBitLength - this.fHead;
            BitPacking.writeInt(this.fBuffer, this.fHead, firstChunkLength, value >> bitLength - firstChunkLength);
            this.fHead = newHeadPosition - maxBitLength;
            BitPacking.writeInt(this.fBuffer, 0, this.fHead, value);
        }
        if (!$assertionsDisabled && this.fHead > maxBitLength) {
            throw new AssertionError();
        }
        if (this.fHead == maxBitLength) {
            this.fHead = 0;
        }
    }

    public final void packUnsigned(long value, boolean isLong) {
        if (value == 0L || value == 1L) {
            this.writeInt(1, 1);
            this.writeInt(1, (int)value);
            return;
        }
        int msbOfValue = 1;
        long tmpVal = value;
        while ((tmpVal >>>= 1) != 0L) {
            ++msbOfValue;
        }
        int msbOfMSB = 0;
        int tmpMSB = msbOfValue;
        while ((tmpMSB >>>= 1) != 0) {
            ++msbOfMSB;
        }
        Assertion.wilyAssert(msbOfMSB > 0);
        this.writeInt(msbOfMSB, 0);
        this.writeInt(msbOfMSB + 1, msbOfValue);
        this.writeLong(--msbOfValue, value & (1L << msbOfValue ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public final void packUnsigned(int value, boolean isLong) {
        this.packUnsigned((long)value & 0xFFFFFFFFL, isLong);
    }

    public int readInt(int bitLength) {
        int result;
        if (this.fBuffer == null) {
            this.fReadCursor += bitLength;
            return 0;
        }
        int newCursorPosition = this.fReadCursor + bitLength;
        int maxBitLength = this.getBitLength();
        if (newCursorPosition <= maxBitLength) {
            result = BitPacking.readInt(this.fBuffer, this.fReadCursor, bitLength);
            this.fReadCursor = newCursorPosition;
        } else {
            int firstChunkLength = maxBitLength - this.fReadCursor;
            result = BitPacking.readInt(this.fBuffer, this.fReadCursor, firstChunkLength) << bitLength - firstChunkLength;
            this.fReadCursor = newCursorPosition - maxBitLength;
            result |= BitPacking.readInt(this.fBuffer, 0, this.fReadCursor);
        }
        if (this.fReadCursor == maxBitLength) {
            this.fReadCursor = 0;
        }
        return result;
    }

    public final long readLong(int bitLength) {
        long result;
        if (this.fBuffer == null) {
            this.fReadCursor += bitLength;
            return 0L;
        }
        int newCursorPosition = this.fReadCursor + bitLength;
        int maxBitLength = this.getBitLength();
        if (newCursorPosition <= maxBitLength) {
            result = BitPacking.readLong(this.fBuffer, this.fReadCursor, bitLength);
            this.fReadCursor = newCursorPosition;
        } else {
            int firstChunkLength = maxBitLength - this.fReadCursor;
            result = BitPacking.readLong(this.fBuffer, this.fReadCursor, firstChunkLength) << bitLength - firstChunkLength;
            this.fReadCursor = newCursorPosition - maxBitLength;
            result |= BitPacking.readLong(this.fBuffer, 0, this.fReadCursor);
        }
        if (this.fReadCursor == maxBitLength) {
            this.fReadCursor = 0;
        }
        return result;
    }

    public long unpackUnsigned(boolean expectLong) {
        int msbOfMSB = 0;
        while (this.readInt(1) == 0) {
            ++msbOfMSB;
        }
        if (msbOfMSB == 0) {
            return this.readInt(1);
        }
        int msbOfValue = (1 << msbOfMSB | this.readInt(msbOfMSB)) - 1;
        return 1L << msbOfValue | this.readLong(msbOfValue);
    }

    private final void ensureCapacity(int numBits) {
        int freeBits = this.fTail - this.fHead - 1;
        if (freeBits < 0) {
            freeBits += this.getBitLength();
        }
        if (freeBits < numBits) {
            this.expandBits(numBits);
        }
    }

    private void expandBits(int numBits) {
        int newInts;
        if (this.fTail == 0 && (this.fBuffer.length & 0x3FFF) == 0) {
            newInts = 16384;
        } else {
            newInts = (numBits + 31 >> 5) + 2;
            int bitsToNextEvenBoundary = newInts & 3;
            if (bitsToNextEvenBoundary != 0) {
                newInts += 4 - bitsToNextEvenBoundary;
            }
        }
        int newSize = this.fBuffer.length + newInts;
        int[] newBuffer = new int[newSize];
        int tail = this.fTail >> 5;
        Assertion.wilyAssert(newBuffer != null);
        if (this.fTail < this.fHead) {
            System.arraycopy(this.fBuffer, tail, newBuffer, tail, (this.fHead - 1 >> 5) - tail + 1);
        } else {
            if (this.fHead != 0) {
                System.arraycopy(this.fBuffer, 0, newBuffer, 0, (this.fHead - 1 >> 5) + 1);
            }
            System.arraycopy(this.fBuffer, tail, newBuffer, tail + newInts, this.fBuffer.length - tail);
            int newBits = newInts << 5;
            if (this.fReadCursor >= this.fTail) {
                this.fReadCursor += newBits;
            }
            this.fTail += newBits;
        }
        this.fBuffer = newBuffer;
    }

    public void writeTo(DataOutput out) throws IOException {
        int tempTail = 0;
        int index = 0;
        while (tempTail < this.fHead) {
            out.write(this.fBuffer[index++]);
            tempTail += 8;
        }
    }

    public static long usedMem(Runtime runtime) {
        return runtime.totalMemory() - runtime.freeMemory();
    }

    public static void runGC(Runtime runtime) {
        int loop1 = 0;
        while (loop1 < 4) {
            long memUsedNow = CircularBitArray.usedMem(runtime);
            long lastMemUsed = Long.MAX_VALUE;
            int loop2 = 0;
            while (memUsedNow < lastMemUsed && loop2 < 500) {
                runtime.runFinalization();
                runtime.gc();
                Thread.currentThread();
                Thread.yield();
                lastMemUsed = memUsedNow;
                memUsedNow = CircularBitArray.usedMem(runtime);
                ++loop2;
            }
            ++loop1;
        }
    }

    public static void main(String[] args) {
        Runtime rt = Runtime.getRuntime();
        CircularBitArray.runGC(rt);
        CircularBitArray[] test = new CircularBitArray[100000];
        new CircularBitArray();
        CircularBitArray.runGC(rt);
        long before = CircularBitArray.usedMem(rt);
        int i = 0;
        while (i < test.length) {
            test[i] = new CircularBitArray();
            ++i;
        }
        CircularBitArray.runGC(rt);
        long after = CircularBitArray.usedMem(rt);
        System.out.println("Structure size: " + ((double)after - (double)before) / 100000.0);
    }
}

