/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.exception;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;

public abstract class AChainingRuntimeException
extends RuntimeException {
    static final long serialVersionUID = 1L;
    private transient Throwable fCause = this;

    protected AChainingRuntimeException() {
    }

    protected AChainingRuntimeException(String message) {
        super(message);
    }

    protected AChainingRuntimeException(Throwable cause) {
        super(cause.getMessage());
        this.initCause(cause);
    }

    protected AChainingRuntimeException(String message, Throwable cause) {
        super(String.valueOf(message) + " (" + cause.getMessage() + ")");
        this.initCause(cause);
    }

    public Throwable initCause(Throwable cause) {
        if (this.fCause != this) {
            throw new IllegalStateException("Can't overwrite cause");
        }
        if (cause == this) {
            throw new IllegalArgumentException("Self-causation not permitted");
        }
        this.fCause = cause;
        return this;
    }

    public Throwable getCause() {
        return this.fCause == this ? null : this.fCause;
    }

    private boolean shouldManuallyTraceCause() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            Throwable t;
            super.printStackTrace(s);
            if (this.shouldManuallyTraceCause() && (t = this.getCause()) != null) {
                s.println("caused by:");
                t.printStackTrace(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            Throwable t;
            super.printStackTrace(s);
            if (this.shouldManuallyTraceCause() && (t = this.getCause()) != null) {
                s.println("[manual cause trace] caused by:");
                t.printStackTrace(s);
            }
        }
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.fCause);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.fCause = (Throwable)in.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.fCause = new RuntimeException("Root cause not available in the client.");
        }
    }
}

