/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.resource;

import com.wily.util.io.ExtendedFile;
import com.wily.util.resource.IResource;
import com.wily.util.resource.IResourceReader;
import com.wily.util.resource.IResourceWriter;
import com.wily.util.resource.file.FileBasedResourceReader;
import com.wily.util.resource.file.FileBasedResourceWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class FileBasedResource
implements IResource {
    private final File fSource;

    public FileBasedResource(String source) {
        if (source == null) {
            throw new IllegalArgumentException("source cannot be null");
        }
        this.fSource = ExtendedFile.getCanonicalFile(source);
    }

    public boolean IResource_isFileResource() {
        return true;
    }

    public String IResource_getLocation() {
        return this.fSource.getAbsolutePath();
    }

    public URL IResource_getURL() throws MalformedURLException {
        return this.fSource.toURL();
    }

    public InputStream IResource_getContents() throws IOException {
        return new FileInputStream(this.fSource);
    }

    public FileReader IResource_getSourceContents() throws IOException {
        return new FileReader(this.fSource);
    }

    public IResourceReader IResource_getResourceReader() {
        return new FileBasedResourceReader(this.fSource);
    }

    public IResourceWriter IResource_getResourceWriter() {
        return new FileBasedResourceWriter(this.fSource);
    }

    protected File getFile() {
        return this.fSource;
    }

    public static final IResource getRelativeResourceIfNotAbsolute(String source, IResource contextResource) {
        File inputFile = new File(source);
        IResource rLog = inputFile.isAbsolute() ? new FileBasedResource(source) : FileBasedResource.getRelativeResource(source, contextResource);
        return rLog;
    }

    public static IResource getRelativeResource(String source, IResource contextResource) {
        FileBasedResource result = new FileBasedResource(source);
        try {
            if (contextResource != null && contextResource.IResource_isFileResource()) {
                String relPath = "." + File.separator + source;
                File relFile = new File(relPath);
                File inputFile = new File(source);
                if (relFile.getCanonicalPath().equals(inputFile.getCanonicalPath())) {
                    FileBasedResource contextFileResource = (FileBasedResource)contextResource;
                    File contextFile = contextFileResource.getFile();
                    if (contextFile.exists() && !contextFile.isDirectory()) {
                        contextFile = contextFile.getParentFile();
                    }
                    String contextDirString = contextFile.getCanonicalPath();
                    String fullPath = String.valueOf(contextDirString) + File.separator + source;
                    result = new FileBasedResource(fullPath);
                }
            }
        }
        catch (Exception exception) {}
        return result;
    }
}

