/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.soa.wm.tn.agent.tracers;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.errors.Log;
import com.wily.introscope.agent.trace.BlamePointTracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.introscope.soa.wm.tn.agent.tracers.WmTNRoutingBlameStack;
import com.wily.introscope.soa.wm.tn.agent.util.WmCache;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import com.wily.introscope.spec.metric.ESEException;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.util.Vector;

public class BlamedAndErrorReportingTracer
extends BlamePointTracer {
    public BlamedAndErrorReportingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        String procRule;
        String documentName;
        String documentType;
        String error_cls = this.getParameter("error_cls");
        String parentname = this.getParameter("ParentResource");
        Vector<String> lstErrors = WmTNRoutingBlameStack.getErrors(error_cls);
        if (lstErrors != null) {
            int i = 0;
            while (i < lstErrors.size()) {
                String errorMessage = lstErrors.get(i);
                if (ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)errorMessage)) {
                    String component = this.formatParameterizedName(data);
                    String name = String.valueOf(component) + ":Errors Per Interval";
                    try {
                        this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(name).ILongIntervalCounterDataAccumulator_addSingleIncident();
                        this.recordErrorAtParentResource(parentname);
                    }
                    catch (BadlyFormedNameException e) {
                        e.printStackTrace();
                    }
                    catch (ConflictingTypesException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        if (data.hasInvocationThrownException()) {
            this.error_ITracer_finishTrace(tracerIndex, data);
        }
        if ((documentType = WmCache.getDocumentType()) != null) {
            this.getComponentTracer().addExtraParameter("DocumentType", documentType);
        }
        if ((documentName = WmCache.getDocumentName()) != null) {
            this.getComponentTracer().addExtraParameter("DocumentName", documentName);
        }
        if ((procRule = WmCache.getRule()) != null) {
            this.getComponentTracer().addExtraParameter("ProcRule", procRule);
        }
        super.ITracer_finishTrace(tracerIndex, data);
    }

    private final void recordErrorAtParentResource(String name) {
        int nDelimiterIndex;
        if (name != null && (nDelimiterIndex = name.indexOf(":")) != -1) {
            try {
                this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(name).ILongIntervalCounterDataAccumulator_addSingleIncident();
            }
            catch (Exception e) {
                WMUtils.getLogger().error(e.getMessage());
                WMUtils.getLogger().debug((Throwable)e);
            }
        }
    }

    private final void error_ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (data.hasInvocationThrownException()) {
            if (Log.out.isDebugEnabled()) {
                ProbeIdentification probe = data.getProbeInformation().getProbeIdentification();
                Log.out.debug("ExceptionErrorReporter: " + probe.getRuntimeFullClassName() + "." + probe.getProbeMethodName() + " threw an exception");
            }
            Throwable error = data.getInvocationThrownException();
            String component = this.formatParameterizedName(data);
            String name = String.valueOf(component) + ":Errors Per Interval";
            String errorMessage = error.getMessage();
            if (ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)errorMessage)) {
                try {
                    this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
                    this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(name).ILongIntervalCounterDataAccumulator_addSingleIncident();
                    String parentname = this.getParameter("ParentResource");
                    this.recordErrorAtParentResource(parentname);
                }
                catch (ESEException eSEException) {
                    Assertion.wilyFail((String)"Metric type conflict");
                }
            }
        }
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        try {
            new CorrelationId();
            this.getComponentTracer().getCrossProcessDataCache().getCorrelationID();
        }
        catch (Exception e) {
            WMUtils.getLogger().error(e.getMessage());
            WMUtils.getLogger().debug((Throwable)e);
        }
        super.ITracer_startTrace(tracerIndex, data);
    }
}

