/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.adapters.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ICacheableBlameKeyNameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class AdapterServiceNameFormatter
implements ICacheableBlameKeyNameFormatter {
    private IAgent fAgent;

    public AdapterServiceNameFormatter(IAgent agent) {
        this.fAgent = agent;
    }

    protected IAgent getAgent() {
        return this.fAgent;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        try {
            Object adapterSvc = data.getInvocationObject();
            if (adapterSvc != null && name != null) {
                if (name.indexOf("{adaptertype}", 0) >= 0) {
                    String adaptertype = null;
                    adaptertype = (String)WMUtils.invokeMethodOnObject(adapterSvc, "getAdapterTypeName");
                    if ((adaptertype = WMUtils.formatToBeResourceSafe(adaptertype)) == null || adaptertype.length() == 0) {
                        adaptertype = "UnknownType";
                    }
                    name = StringUtils.replace((String)name, (String)"{adaptertype}", (String)adaptertype);
                    WMUtils.getLogger().debug("AdapterServiceNameFormatter::type:" + adaptertype);
                }
                if (name.indexOf("{adaptername}", 0) >= 0) {
                    String adaptername = null;
                    Object idataObj = data.getInvocationParameterAsObject(0);
                    Object[] objArr = new Object[]{idataObj, "$connectionName"};
                    adaptername = WMUtils.invokeGetStringOnValuesEmulator(objArr);
                    if (adaptername != null) {
                        WMUtils.getLogger().debug("Got Connection name from input params::" + adaptername);
                    }
                    if (adaptername == null || adaptername.trim().equals("")) {
                        adaptername = (String)WMUtils.invokeMethodOnObject(adapterSvc, "getConnectionName");
                    }
                    if ((adaptername = WMUtils.formatToBeResourceSafe(adaptername)) == null || adaptername.length() == 0) {
                        adaptername = "UnknownConnection";
                    }
                    name = StringUtils.replace((String)name, (String)"{adaptername}", (String)adaptername);
                    WMUtils.getLogger().debug("AdapterServiceNameFormatter::connection:" + adaptername);
                }
                if (name.indexOf("{adapterservice}", 0) >= 0) {
                    String svcname = null;
                    svcname = adapterSvc.toString();
                    svcname = WMUtils.convertToServiceNode(svcname);
                    if ((svcname = WMUtils.formatToBeResourceSafe(svcname)) == null || svcname.length() == 0) {
                        svcname = "UnknownService";
                    }
                    name = StringUtils.replace((String)name, (String)"{adapterservice}", (String)svcname);
                    WMUtils.getLogger().debug("AdapterServiceNameFormatter::Svc name:" + svcname);
                }
            } else {
                name = StringUtils.replace((String)name, (String)"{adapterservice}", (String)"UnknownService");
                name = StringUtils.replace((String)name, (String)"{adaptertype}", (String)"UnknownType");
            }
        }
        catch (Throwable bomb) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_NAMEFORMATTER", bomb);
        }
        return name;
    }

    public Object getObjectKey(IModuleFeedbackChannel imodulefeedbackchannel, int i, InvocationData invocationdata) {
        return null;
    }

    public IBlameComponent getKey(IModuleFeedbackChannel imodulefeedbackchannel, String name, InvocationData data) {
        try {
            return ABlameComponent.getArrayInstance((Object[])new Object[]{name, data.getInvocationObject().toString()});
        }
        catch (Exception e) {
            WMUtils.getLogger().error(e.getMessage());
            return null;
        }
    }
}

