/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.bproc.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ICacheableBlameKeyNameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.soaextension.webmethods.bproc.BPCache;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class BPFServiceFormatter
implements ICacheableBlameKeyNameFormatter {
    private static final String kProbeMethod_handleServiceError = "handleServiceError";
    private static final String kProbeMethod_invokeWrapper = "invokeWrapper";
    private IAgent fAgent;

    public BPFServiceFormatter(IAgent agent) {
        this.fAgent = agent;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        String svcname = null;
        String processName = null;
        String sid = null;
        try {
            svcname = this.getServiceName(data);
            processName = BPCache.getProcessName();
            if (StringUtils.isEmpty((String)processName)) {
                processName = "UnknownProcess";
            }
            if (StringUtils.isEmpty((String)(sid = BPCache.getStepsId()))) {
                sid = "UnknownStep";
            }
            svcname = StringUtils.replace((String)svcname, (String)":", (String)"|");
            name = name.replaceAll("\\{processName\\}", processName);
            name = name.replaceAll("\\{sid\\}", sid);
            name = name.replaceAll("\\{svcname\\}", svcname);
        }
        catch (Throwable t) {
            name = name.replaceAll("\\{processName\\}", "UnknownProcess");
            name = name.replaceAll("\\{sid\\}", "UnknownStep");
            name = name.replaceAll("\\{svcname\\}", "UnknownService");
            WMUtils.handleError(this.fAgent, "ERROR_IN_BP_FS_FMTR", t);
        }
        return name;
    }

    private String getServiceName(InvocationData data) {
        String svcname = null;
        String strProbeMethodName = data.getProbeInformation().getProbeIdentification().getProbeMethodName();
        if (strProbeMethodName.equals(kProbeMethod_invokeWrapper)) {
            svcname = (String)data.getInvocationParameterAsObject(0);
        } else if (strProbeMethodName.equals(kProbeMethod_handleServiceError)) {
            svcname = (String)data.getInvocationParameterAsObject(2);
        }
        return svcname;
    }

    public Object getObjectKey(IModuleFeedbackChannel imodulefeedbackchannel, int i, InvocationData invocationdata) {
        return null;
    }

    public IBlameComponent getKey(IModuleFeedbackChannel imodulefeedbackchannel, String name, InvocationData data) {
        try {
            return ABlameComponent.getArrayInstance((Object[])new Object[]{name, BPCache.getProcessName(), BPCache.getStepsId(), this.getServiceName(data)});
        }
        catch (Exception e) {
            imodulefeedbackchannel.error(e.getMessage());
            return null;
        }
    }
}

