/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.bproc.tracer.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.soaextension.webmethods.bproc.BPCache;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;
import java.util.HashMap;
import java.util.Map;

public class BPProcessTracer
extends BlamePointTracer
implements IInvocationDataParameterCallback {
    private IAgent fAgent;

    public BPProcessTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fAgent = agent;
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        super.ITracer_finishTrace(tracerIndex, data);
    }

    private void postProcessLevelMetrics(int tracerIndex, InvocationData data, String component) {
        WMUtils.getLogger().debug("BPProcessTracer.ITracer_finishTrace: Computing 'Average response time' of the process");
        try {
            long pstartTime = 0L;
            String processName = BPCache.getProcessName();
            Object pstartTimeexists = BPCache.get(processName);
            if (pstartTimeexists == null) {
                HashMap pMap = (HashMap)BPCache.getPipelineMap();
                if (pMap != null && pMap.containsKey(processName)) {
                    pstartTime = (Long)pMap.get(processName);
                }
            } else {
                pstartTime = (Long)pstartTimeexists;
            }
            WilyTransactionElement we = (WilyTransactionElement)data.getStartCursorAt(tracerIndex);
            WilyTransactionElement start = (WilyTransactionElement)we.getStartTraceBlamePoint();
            long startTime = data.getWallClockStartTime();
            long endTime = data.getWallClockFinishTime();
            IRepository rep = start.getPerIntervalRepository();
            if (rep != null) {
                rep.update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
            }
            if (pstartTime > 0L) {
                WMUtils.getLogger().debug("BPProcessTracer.ITracer_finishTrace():Retreiving start time " + pstartTime);
                WMUtils.getLogger().debug("BPProcessTracer.ITracer_finishTrace():Retreiving End time " + data.getWallClockFinishTime());
                long avgResponseTime = data.getWallClockFinishTime() - pstartTime;
                WMUtils.getLogger().debug("BPProcessTracer.ITracer_finishTrace():avgResponseTime is " + avgResponseTime);
                if (avgResponseTime >= 0L) {
                    rep = start.getTimerRepository();
                    if (rep != null) {
                        rep.update(BlamePointTracer.getUpdater(), avgResponseTime, pstartTime, endTime);
                    }
                } else if (processName != null) {
                    WMUtils.getLogger().error("Process start time of " + processName + " is manipulated, ART is not posted");
                } else {
                    WMUtils.getLogger().error("Process start time is manipulated, ART is not posted");
                }
            } else if (pstartTime == 0L) {
                if (processName != null) {
                    WMUtils.getLogger().warn("Process start time of " + processName + " is not found, ART is not posted");
                } else {
                    WMUtils.getLogger().warn("Process start time is not found, ART is not posted");
                }
            } else if (processName != null) {
                WMUtils.getLogger().error("Process start time of " + processName + " is manipulated, ART is not posted");
            } else {
                WMUtils.getLogger().error("Process start time is manipulated, ART is not posted");
            }
            BPCache.remove(BPCache.getPipelineMap());
        }
        catch (Throwable t) {
            WMUtils.handleError(this.fAgent, "ERROR_IN_STEPTRACER_FT_POST_PROCESS_METRICS", t);
            t.printStackTrace();
        }
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        data.setParameterCallback((IInvocationDataParameterCallback)this);
        super.doStartBlamePointTrace(tracerIndex, data);
    }

    public void doOnEndTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        InvocationData data = (InvocationData)elementData;
        String component = data.getComponentNameAt(tracerIndex);
        WMUtils.getLogger().debug("BPProcessTracer.ITracer_finishTrace() component=" + component);
        if (BPCache.isProcessComplete()) {
            this.postProcessLevelMetrics(tracerIndex, data, component);
        }
    }

    public void doOnStartTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        InvocationData data = (InvocationData)elementData;
        data.setStartCursorAt(element, tracerIndex);
    }

    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
        String processname;
        String tt_filter_param_key = this.getParameter("WM_SERVICE_TYPE");
        if (data.getInvocationObject() != null && (processname = BPCache.getProcessName()) != null) {
            parameters.put(tt_filter_param_key, processname);
        }
    }

    public WilyTransactionElement constructTransactionElement(Object key, String metricName, int blameStatus, boolean b, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, ProbeInformation probeInformation) {
        HashMap<IRepository, AgentMetric[]> metrics = new HashMap<IRepository, AgentMetric[]>(3);
        IRepository timerSds = null;
        IRepository perIntervalSds = null;
        IRepository errorsSds = null;
        AgentMetric[] timerMetric = this.createTimerMetric(this.getTimerMetricName(metricName));
        timerSds = BlamePointTracer.getAverageMetricRepository();
        metrics.put(timerSds, timerMetric);
        AgentMetric[] perIntervalMetric = this.createPerIntervalMetric(this.getPerIntervalMetricName(metricName));
        perIntervalSds = BlamePointTracer.getCountQueuedRepository((boolean)true);
        metrics.put(perIntervalSds, perIntervalMetric);
        if (this.shouldForceStandardBlameMetrics()) {
            AgentMetric[] errorMetric = this.createErrorsMetric(this.getErrorsMetricName(metricName));
            errorsSds = BlamePointTracer.getCountQueuedRepository((boolean)true);
            metrics.put(errorsSds, errorMetric);
        }
        WilyTransactionElement result = new WilyTransactionElement(key, metricName, this.getBlameStatus(), true, parent, previous, start, metrics, timerSds, perIntervalSds, null, errorsSds, null, probeInformation, false, false);
        return result;
    }
}

