/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.bproc.tracer80.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.feature.StallFeatureBase;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.ICounterRepository;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.soaextension.webmethods.bproc.BPCache;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;
import java.util.Date;

public class BPStepTracer80
extends BlamePointTracer {
    private IAgent fAgent;
    private boolean fShouldDoStalls;
    private static final String kShouldDoStallsKey = "dostalls";

    public BPStepTracer80(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fAgent = agent;
        this.fShouldDoStalls = this.calculateBooleanParameter(kShouldDoStallsKey, true);
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        String component = data.getComponentNameAt(tracerIndex);
        WMUtils.getLogger().debug("BPStepTracer.ITracer_finishTrace() component=" + component);
        super.ITracer_finishTrace(tracerIndex, data);
    }

    private void postStepLevelMetrics(int tracerIndex, InvocationData data, WilyTransactionElement start) {
        try {
            String component = data.getComponentNameAt(tracerIndex);
            WMUtils.getLogger().debug("BPStepTracer:postStepLevelMetrics::component:" + component);
            if (!BPCache.isIntermediateStep()) {
                Object sdaObj = data.getInvocationObject();
                boolean isSubEnd = false;
                isSubEnd = WMUtils.getIsSubEnd(sdaObj);
                if (!BPCache.isSrcIntermediate() && !isSubEnd) {
                    long startTime = 0L;
                    if (data.getInvocationParameterCount() > 0) {
                        Date startDate = (Date)data.getInvocationParameterAsObject(0);
                        if (startDate != null) {
                            startTime = startDate.getTime();
                            WMUtils.getLogger().debug("BPStepTracer.ITracer_finishTrace:startDate(execute start time)" + startTime);
                        } else {
                            startTime = data.getWallClockStartTime();
                            WMUtils.getLogger().debug("BPStepTracer.ITracer_finishTrace:Blame stack start time)" + startTime);
                        }
                    } else {
                        startTime = data.getWallClockStartTime();
                        WMUtils.getLogger().debug("BPStepTracer.ITracer_finishTrace:Blame stack start time)" + startTime);
                    }
                    long endTime = data.getWallClockFinishTime();
                    long avgResponseTime = endTime - startTime;
                    IRepository rep = start.getTimerRepository();
                    if (rep != null) {
                        rep.update(BlamePointTracer.getUpdater(), avgResponseTime, startTime, endTime);
                    }
                    if ((rep = start.getPerIntervalRepository()) != null) {
                        rep.update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
                    }
                    WMUtils.getLogger().debug("BPStepTracer.ITracer_finishTrace:normal step responseTime " + avgResponseTime);
                } else if (BPCache.isRunStep()) {
                    String key = BPCache.getStepsId();
                    Long stepStartTime = (Long)BPCache.get(key);
                    long avgResponseTime = 0L;
                    long endTime = data.getWallClockFinishTime();
                    long startTime = 0L;
                    if (stepStartTime != null && stepStartTime > 0L) {
                        startTime = stepStartTime;
                        avgResponseTime = endTime - startTime;
                    }
                    WMUtils.getLogger().debug("BPStepTracer.ITracer_finishTrace:stepStartTime " + stepStartTime);
                    WMUtils.getLogger().debug("BPStepTracer.ITracer_finishTrace:avgResponseTime " + avgResponseTime);
                    if (avgResponseTime == 0L) {
                        WMUtils.getLogger().debug("BPStepTracer.ITracer_finishTrace(): Intermediate step start time is not found for:" + component.substring(component.indexOf("Business Processes|") + 19));
                        startTime = data.getWallClockStartTime();
                        avgResponseTime = endTime - startTime;
                    } else if (avgResponseTime < 0L) {
                        WMUtils.getLogger().error("Intermediate step start time is manipulated for:" + component.substring(component.indexOf("Business Processes|") + 19));
                        startTime = data.getWallClockStartTime();
                        avgResponseTime = endTime - startTime;
                    }
                    IRepository rep = start.getTimerRepository();
                    if (rep != null) {
                        rep.update(BlamePointTracer.getUpdater(), avgResponseTime, startTime, endTime);
                    }
                    if ((rep = start.getPerIntervalRepository()) != null) {
                        rep.update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
                    }
                    WMUtils.getLogger().debug("BPStepTracer.ITracer_finishTrace:aggregated avgResponseTime " + avgResponseTime);
                }
            }
        }
        catch (Throwable t) {
            WMUtils.handleError(this.fAgent, "ERROR_IN_STEPTRACER_FT_POST_STEP_METRICS", t);
        }
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        try {
            data.storeWallClockStartTime();
            super.doStartBlamePointTrace(tracerIndex, data);
            String oriSid = null;
            String sid = null;
            oriSid = BPCache.getOriStepID();
            sid = BPCache.getStepsId();
            BPCache.setSpEnd(BPStepTracer80.isSubPrcsEndStep(oriSid));
            Boolean procStarted = BPCache.isProcessStarted();
            if (procStarted != null && procStarted.booleanValue()) {
                this.setProcessStartTimetoCache(data);
            }
            BPCache.setProcessStarted(false);
            if (BPStepTracer80.isinterstep(oriSid)) {
                this.setInterStepStartTimeToCache(data, sid);
            } else {
                BPCache.setIntermediateStep(false);
            }
        }
        catch (Throwable t) {
            WMUtils.handleError(this.fAgent, "ERROR_IN_STEPTRACER", t);
            System.out.println(t.getMessage());
            t.printStackTrace();
        }
    }

    private void setInterStepStartTimeToCache(InvocationData data, String sid) {
        Date startTimeD;
        WMUtils.getLogger().debug("BPStepTracer.ITracer_startTrace() setting intermediate step to true");
        BPCache.setIntermediateStep(true);
        long startTime = 0L;
        startTime = data.getInvocationParameterCount() > 0 ? ((startTimeD = (Date)data.getInvocationParameterAsObject(0)) != null ? startTimeD.getTime() : data.getWallClockStartTime()) : data.getWallClockStartTime();
        BPCache.put(sid, startTime);
        WMUtils.getLogger().debug("BPStepTracer.startTrace() Storing start time of interstep " + data.getWallClockStartTime() + "to Cache");
    }

    private void setProcessStartTimetoCache(InvocationData data) {
        Date startDate;
        long startTime = 0L;
        startTime = data.getInvocationParameterCount() > 0 ? ((startDate = (Date)data.getInvocationParameterAsObject(0)) != null ? startDate.getTime() : data.getWallClockStartTime()) : data.getWallClockStartTime();
        BPCache.setProcessStartTime(startTime);
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    public static boolean isinterstep(String stepname) {
        boolean interstep = false;
        if (stepname.contains("PRESUB_")) {
            interstep = true;
        } else if (stepname.contains("PRETDE_")) {
            interstep = true;
        } else if (stepname.contains("_Start")) {
            interstep = true;
        }
        return interstep;
    }

    public static boolean isSubPrcsEndStep(String stepname) {
        boolean spend = false;
        if (stepname.endsWith("_End")) {
            spend = true;
        }
        return spend;
    }

    public void doOnEndTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        InvocationData data = (InvocationData)elementData;
        data.setFinished(true);
        if (element instanceof WilyTransactionElement) {
            data.getWallClockStartTime();
            long endTime = data.getWallClockFinishTime();
            WilyTransactionElement we = (WilyTransactionElement)element;
            WilyTransactionElement start = (WilyTransactionElement)we.getStartTraceBlamePoint();
            this.postStepLevelMetrics(tracerIndex, data, start);
            ICounterRepository cin = start.getConcurrentInvocations();
            if (cin != null) {
                cin.decrease(endTime);
            } else {
                ICounterRepository[] repArray = start.getConcurrentInvocationsRepositoryAsArray();
                int i = 0;
                while (i < repArray.length) {
                    if (repArray[i] != null) {
                        repArray[i].decrease(endTime);
                    }
                    ++i;
                }
            }
        }
        if (this.fShouldDoStalls) {
            StallFeatureBase.putValidParentInStallPoint((IStackElement)elementData);
        }
    }

    protected boolean subscribeToDownstreamErrors() {
        return false;
    }

    protected boolean subscribeToDownstreamStalls() {
        return false;
    }
}

