/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.services.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.spec.metric.ESEException;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;

public class WMErrorReportingTracer
extends ASingleMetricTracerFactory {
    public WMErrorReportingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected IDataAccumulator createDataAccumulator(String arg0) {
        return null;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        try {
            String component = this.formatParameterizedResource(data);
            this.getAgent().IAgent_getComponentTracer().addComponent(component);
        }
        catch (Throwable bomb) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", bomb);
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        try {
            String errorMessage;
            boolean recordError;
            boolean acl;
            String component = this.formatParameterizedResource(data);
            Boolean retObj = (Boolean)data.getInvocationReturnValueAsObject();
            if (retObj != null && !(acl = retObj.booleanValue()) && (recordError = ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)(errorMessage = "An AccessException Occured in WebMethods::Access Denied")))) {
                this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
                String name = this.formatParameterizedName(data);
                this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(name).ILongIntervalCounterDataAccumulator_addSingleIncident();
            }
            this.getAgent().IAgent_getComponentTracer().removeComponent(component);
        }
        catch (ESEException e) {
            Assertion.wilyFail((String)("Metric type conflict" + e.getMessage()));
        }
        catch (Throwable bomb) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", bomb);
        }
    }
}

