/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.webservices.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.BlamePointTracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.InvocationTargetException;

public class WSBlamePointTracer
extends BlamePointTracer {
    protected static final String kLoggerErrorKey = "ERROR_IN_WM_TRACER";

    public WSBlamePointTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        WMUtils.getLogger().debug("WSBlamePointTracer::startTrace()");
        try {
            Object wsdObj = null;
            String soapactionObj = null;
            wsdObj = data.getInvocationParameterAsObject(6);
            soapactionObj = (String)data.getInvocationParameterAsObject(2);
            if (data != null && wsdObj != null) {
                this.process(tracerIndex, data, wsdObj, soapactionObj);
            }
        }
        catch (Exception e) {
            WMUtils.handleError(this.getAgent(), kLoggerErrorKey, e);
        }
    }

    protected void process(int tracerIndex, InvocationData data, Object wsdObj, Object soapaction) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Object binderObj = null;
        try {
            Class[] clArr = new Class[]{String.class};
            Object[] obArr = new Object[]{soapaction};
            binderObj = WMUtils.invokeMethodOnObject(wsdObj, "findBinder", clArr, obArr);
        }
        catch (Exception e) {
            WMUtils.handleError(this.getAgent(), kLoggerErrorKey, e);
        }
        if (binderObj != null) {
            String component = this.getComponentName(data);
            data.setComponentNameAt(component, tracerIndex);
            String nameSpace = (String)data.get("com.wily.soaextension.webmethods.webservices.NamespaceKey");
            String operationName = (String)data.get("com.wily.soaextension.webmethods.webservices.OperationNameKey");
            if (nameSpace != null && nameSpace.length() > 0) {
                this.getComponentTracer().addExtraParameter("namespace", nameSpace);
            }
            if (operationName != null && operationName.length() > 0) {
                this.getComponentTracer().addExtraParameter("operationname", operationName);
            }
            data.put("BinderNotNull", (Object)true);
            super.ITracer_startTrace(tracerIndex, data);
        } else {
            data.put("BinderNotNull", (Object)false);
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        WMUtils.getLogger().debug("WSBlamePointTracer::finishTrace()");
        try {
            boolean binderNotNull = (Boolean)data.get("BinderNotNull");
            if (binderNotNull) {
                super.ITracer_finishTrace(tracerIndex, data);
            }
        }
        catch (Exception e) {
            WMUtils.handleError(this.getAgent(), kLoggerErrorKey, e);
            WMUtils.getLogger().debug(e.getMessage());
        }
    }
}

