/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.webservices.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.spec.metric.ESEException;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;

public class WSSoapErrorReportingTracer
extends ASingleMetricTracerFactory {
    public WSSoapErrorReportingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected IDataAccumulator createDataAccumulator(String arg0) {
        return null;
    }

    public void ITracer_finishTrace(int index, InvocationData data) {
        try {
            String component = this.formatParameterizedResource(data);
            if (data.hasInvocationThrownException()) {
                boolean isvalid = false;
                Object endpt = data.get("com.wily.soa.webmethod.wsendpoint.isvalid");
                if (endpt != null) {
                    isvalid = (Boolean)endpt;
                }
                if (isvalid) {
                    WMUtils.getLogger().debug("WSSoapErrorReportingTracer::endpoint valid");
                    String errorMessage = null;
                    Throwable errorObj = data.getInvocationThrownException();
                    String faulttext = errorObj.getLocalizedMessage().trim();
                    String name = null;
                    if (errorObj.getClass().getName().contains("SOAPException")) {
                        name = String.valueOf(component) + ":" + "SOAP Faults Per Interval";
                        errorMessage = faulttext != null ? (!faulttext.equals("") ? "SOAP Fault:" + faulttext : "SOAP Fault:" + component + ":" + "SOAP Fault occured") : "SOAP Fault:" + component + ":" + "SOAP Fault occured";
                        boolean recordFault = ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)errorMessage);
                        if (recordFault) {
                            this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
                        }
                        this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(name).ILongIntervalCounterDataAccumulator_addSingleIncident();
                    } else {
                        errorMessage = faulttext != null ? (!faulttext.equals("") ? faulttext : String.valueOf(component) + ":" + "SOAP Fault occured") : String.valueOf(component) + ":" + "SOAP Fault occured";
                        WMUtils.getLogger().debug("WSSoapErrorReportingTracer::error msg:" + errorMessage);
                        boolean recordError = ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)errorMessage);
                        if (recordError) {
                            this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
                        }
                        name = this.formatParameterizedName(data);
                        this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(name).ILongIntervalCounterDataAccumulator_addSingleIncident();
                    }
                }
            }
        }
        catch (ESEException e) {
            Assertion.wilyFail((String)("Metric type conflict" + e.getMessage()));
        }
        catch (Throwable bomb) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", bomb);
        }
    }

    public void ITracer_startTrace(int index, InvocationData data) {
    }
}

