/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.webservices.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.spec.metric.ESEException;
import com.wily.powerpack.webservices.extension.agent.errors.SoapFaultSnapshotFeatureFactory;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;

public class WebServices65ClientFaultTracer
extends ASingleMetricTracerFactory {
    public WebServices65ClientFaultTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected IDataAccumulator createDataAccumulator(String arg0) {
        return null;
    }

    public void ITracer_finishTrace(int index, InvocationData data) {
        try {
            String component = data.getComponentNameAt(index);
            if (data.hasInvocationThrownException()) {
                try {
                    boolean recordError;
                    Throwable error = data.getInvocationThrownException();
                    String errorMessage = error.getMessage().trim();
                    if (errorMessage != null) {
                        if (errorMessage.equals("")) {
                            errorMessage = String.valueOf(component) + "::" + "Error Occured";
                        }
                    } else {
                        errorMessage = String.valueOf(component) + "::" + "Error Occured";
                    }
                    if (recordError = ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)errorMessage)) {
                        this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
                    }
                    String name = String.valueOf(component) + ":" + "Errors Per Interval";
                    this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(name).ILongIntervalCounterDataAccumulator_addSingleIncident();
                }
                catch (ESEException eSEException) {
                    Assertion.wilyFail((String)"Metric type conflict");
                }
            }
            Object idataObj = data.getInvocationParameterAsObject(0);
            ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
            Object[] objArr = new Object[]{idataObj, "soapResponseData"};
            Class<?> nodeClass = Class.forName("com.wm.lang.xml.Node", false, threadClassLoader);
            Class[] nodeArr = new Class[]{nodeClass};
            boolean hasFault = false;
            Object responseMsg = WMUtils.invokeGetOnValuesEmulator(objArr);
            Object nodeObj = null;
            if (responseMsg != null) {
                Object[] nodes = (Object[])WMUtils.invokeMethodOnObject(responseMsg, "getBodyNodes");
                if (nodes != null) {
                    WMUtils.getLogger().debug("WSClient65FaultTracer::endpoint valid");
                    nodeObj = nodes[0];
                    if (nodeObj != null) {
                        Object localname = WMUtils.invokeMethodOnObject(nodeObj, "getLocalName");
                        WMUtils.getLogger().debug("WSClient65FaultTracer::Got local name as:" + localname.toString());
                        if (localname.toString().equalsIgnoreCase("fault")) {
                            hasFault = true;
                        }
                    }
                }
                if (hasFault) {
                    String errorMessage = null;
                    String faulttext = null;
                    if (nodeObj != null) {
                        Object child2;
                        Object faultChild = WMUtils.invokeMethodOnObject(nodeObj, "getFirstChild");
                        Object[] nodeObjArr = new Object[]{faultChild};
                        nodeObjArr[0] = child2 = WMUtils.invokeMethodOnObject(nodeObj, "getNextSiblingOfChild", nodeArr, nodeObjArr);
                        if (child2 != null) {
                            Object faultStrObj;
                            Object child3;
                            nodeObjArr[0] = child3 = WMUtils.invokeMethodOnObject(nodeObj, "getNextSiblingOfChild", nodeArr, nodeObjArr);
                            if (child3 != null && (faultStrObj = WMUtils.invokeMethodOnObject(nodeObj, "getNextSiblingOfChild", nodeArr, nodeObjArr)) != null) {
                                Object faultString = WMUtils.invokeMethodOnObject(faultStrObj, "getFirstChild");
                                faulttext = faultString.toString();
                            }
                        }
                    }
                    WMUtils.getLogger().debug("Got fault string as:" + faulttext);
                    errorMessage = faulttext != null ? (faulttext.equals("") ? "SOAP Fault:" + component + ":" + "SOAP Fault occured" : "SOAP Fault:" + faulttext) : "SOAP Fault:" + component + ":" + "SOAP Fault occured";
                    boolean recordFault = SoapFaultSnapshotFeatureFactory.flagErrorInManagedApplication((String)errorMessage);
                    if (recordFault) {
                        this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
                    }
                    try {
                        String name = String.valueOf(component) + ":" + "SOAP Faults Per Interval";
                        this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(name).ILongIntervalCounterDataAccumulator_addSingleIncident();
                    }
                    catch (ESEException eSEException) {
                        Assertion.wilyFail((String)"Metric type conflict");
                    }
                }
            } else {
                WMUtils.getLogger().debug("WSClient65FaultTracer::Got response msg as null");
            }
        }
        catch (Exception e) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", e);
            WMUtils.getLogger().debug("Error in Fault Tracer:" + e.getMessage());
        }
    }

    public void ITracer_startTrace(int index, InvocationData data) {
        try {
            String component = this.formatParameterizedName(data);
            data.setComponentNameAt(component, index);
        }
        catch (Exception e) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", e);
            WMUtils.getLogger().debug("Error in Fault Tracer:" + e.getMessage());
        }
    }
}

