/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.webservices.tracer.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.feature.FaultFeature;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;

public class WSSoapErrorReportingTracer
extends ASingleInstanceTracerFactory {
    public WSSoapErrorReportingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int index, InvocationData data) {
        try {
            String component = this.formatParameterizedName(data);
            data.put("ComponentName", (Object)component);
            if (data.hasInvocationThrownException()) {
                boolean isvalid = false;
                Object endpt = data.get("com.wily.soa.webmethod.wsendpoint.isvalid");
                if (endpt != null) {
                    isvalid = (Boolean)endpt;
                }
                if (isvalid) {
                    WMUtils.getLogger().debug("WSSoapErrorReportingTracer::endpoint valid");
                    Throwable errorObj = data.getInvocationThrownException();
                    if (errorObj.getClass().getName().contains("SOAPException")) {
                        data.put("hasFault", (Object)true);
                        String faultMessage = "SOAP Fault::" + this.constructErrorMessage(data);
                        if (faultMessage != null) {
                            FaultFeature.constructAndSendFaultSnapshotToServer((InvocationData)data, (String)faultMessage, (IAgent)this.getAgent());
                            FaultFeature.decorateTransactionsWithFault((InvocationData)data, (String)faultMessage);
                        }
                        FaultFeature.incrementFaultMetric((InvocationData)data);
                    } else {
                        data.put("hasError", (Object)true);
                        String errorMessage = this.constructErrorMessage(data);
                        if (errorMessage != null) {
                            ErrorFeature.constructAndSendErrorSnapshotToServer((InvocationData)data, (String)errorMessage, (IAgent)this.getAgent());
                            ErrorFeature.decorateTransactionsWithError((InvocationData)data, (String)errorMessage);
                        }
                        ErrorFeature.incrementErrorMetric((IStackElement)data);
                    }
                }
            }
        }
        catch (Throwable bomb) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", bomb);
        }
    }

    public void ITracer_startTrace(int index, InvocationData data) {
    }

    protected String constructErrorMessage(InvocationData data) {
        String component = (String)data.get("ComponentName");
        String errorMessage = null;
        if (data.hasInvocationThrownException()) {
            Throwable errorObj = data.getInvocationThrownException();
            String faulttext = errorObj.getLocalizedMessage().trim();
            errorMessage = faulttext != null ? (!faulttext.equals("") ? faulttext : String.valueOf(component) + ":" + "SOAP Fault occured") : String.valueOf(component) + ":" + "SOAP Fault occured";
            WMUtils.getLogger().debug("WSSoapErrorReportingTracer::error msg:" + errorMessage);
        }
        return errorMessage;
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

