/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.webservices.tracer.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.feature.FaultFeature;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;
import java.util.concurrent.atomic.AtomicReference;

public class WebServices65ClientFaultTracer
extends ASingleInstanceTracerFactory {
    private final AtomicReference<IRepository> fFaultRep = new AtomicReference();

    public WebServices65ClientFaultTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int index, InvocationData data) {
        try {
            String component = this.formatParameterizedResource(data);
            data.put("ComponentName", (Object)component);
            if (data.hasInvocationThrownException()) {
                String errorMessage = this.constructErrorMessage(data);
                ErrorFeature.constructAndSendErrorSnapshotToServer((InvocationData)data, (String)errorMessage, (IAgent)this.getAgent());
                ErrorFeature.decorateTransactionsWithError((InvocationData)data, (String)errorMessage);
                ErrorFeature.incrementErrorMetric((IStackElement)data);
            }
            Object idataObj = data.getInvocationParameterAsObject(0);
            ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
            Object[] objArr = new Object[]{idataObj, "soapResponseData"};
            Class<?> nodeClass = Class.forName("com.wm.lang.xml.Node", false, threadClassLoader);
            Class[] nodeArr = new Class[]{nodeClass};
            boolean hasFault = false;
            Object responseMsg = WMUtils.invokeGetOnValuesEmulator(objArr);
            Object nodeObj = null;
            if (responseMsg != null) {
                Object[] nodes = (Object[])WMUtils.invokeMethodOnObject(responseMsg, "getBodyNodes");
                if (nodes != null) {
                    WMUtils.getLogger().debug("WSClient65FaultTracer::endpoint valid");
                    nodeObj = nodes[0];
                    if (nodeObj != null) {
                        Object localname = WMUtils.invokeMethodOnObject(nodeObj, "getLocalName");
                        WMUtils.getLogger().debug("WSClient65FaultTracer::Got local name as:" + localname.toString());
                        if (localname.toString().equalsIgnoreCase("fault")) {
                            hasFault = true;
                        }
                    }
                }
                data.put("hasFault", (Object)hasFault);
                if (hasFault) {
                    String faultMessage = null;
                    String faulttext = null;
                    if (nodeObj != null) {
                        Object child2;
                        Object faultChild = WMUtils.invokeMethodOnObject(nodeObj, "getFirstChild");
                        Object[] nodeObjArr = new Object[]{faultChild};
                        nodeObjArr[0] = child2 = WMUtils.invokeMethodOnObject(nodeObj, "getNextSiblingOfChild", nodeArr, nodeObjArr);
                        if (child2 != null) {
                            Object faultStrObj;
                            Object child3;
                            nodeObjArr[0] = child3 = WMUtils.invokeMethodOnObject(nodeObj, "getNextSiblingOfChild", nodeArr, nodeObjArr);
                            if (child3 != null && (faultStrObj = WMUtils.invokeMethodOnObject(nodeObj, "getNextSiblingOfChild", nodeArr, nodeObjArr)) != null) {
                                Object faultString = WMUtils.invokeMethodOnObject(faultStrObj, "getFirstChild");
                                faulttext = faultString.toString();
                            }
                        }
                    }
                    WMUtils.getLogger().debug("Got fault string as:" + faulttext);
                    faultMessage = faulttext != null ? (faulttext.equals("") ? "SOAP Fault:" + component + ":" + "SOAP Fault occured" : "SOAP Fault:" + faulttext) : "SOAP Fault:" + component + ":" + "SOAP Fault occured";
                    if (faultMessage != null) {
                        FaultFeature.constructAndSendFaultSnapshotToServer((InvocationData)data, (String)faultMessage, (IAgent)this.getAgent());
                        FaultFeature.decorateTransactionsWithFault((InvocationData)data, (String)faultMessage);
                    }
                    FaultFeature.incrementFaultMetric((InvocationData)data);
                }
            } else {
                WMUtils.getLogger().debug("WSClient65FaultTracer::Got response msg as null");
            }
        }
        catch (Exception e) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", e);
            WMUtils.getLogger().debug("Error in Fault Tracer:" + e.getMessage());
        }
    }

    public void ITracer_startTrace(int index, InvocationData data) {
        WMUtils.getLogger().debug("WSClient65FaultTracer::startTrace()");
    }

    protected String constructErrorMessage(InvocationData data) {
        String errorMessage = null;
        Throwable error = data.getInvocationThrownException();
        if (error != null) {
            errorMessage = error.getMessage().trim();
        }
        String component = (String)data.get("ComponentName");
        if (errorMessage != null) {
            if (errorMessage.equals("")) {
                errorMessage = String.valueOf(component) + "::" + "Error Occured";
            }
        } else {
            errorMessage = String.valueOf(component) + "::" + "Error Occured";
        }
        return errorMessage;
    }

    public void doOnEndTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        InvocationData data = (InvocationData)elementData;
        long startTime = data.getWallClockStartTime();
        long endTime = data.getWallClockFinishTime();
        if (data.hasInvocationThrownException()) {
            try {
                String errorMessage = this.constructErrorMessage(data);
                ErrorFeature.constructAndSendErrorSnapshotToServer((InvocationData)data, (String)errorMessage, (IAgent)this.getAgent());
                ErrorFeature.decorateTransactionsWithError((InvocationData)data, (String)errorMessage);
                ErrorFeature.incrementErrorMetric((IStackElement)data);
            }
            catch (Exception e) {
                WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", e);
                WMUtils.getLogger().debug("Error in Fault Tracer:" + e.getMessage());
            }
        }
        boolean hasFault = false;
        if (data.get("hasFault") != null) {
            hasFault = (Boolean)data.get("hasFault");
        }
        if (hasFault) {
            try {
                IRepository newFault;
                AgentMetric faultMetric;
                IRepository prevFault;
                String faultMessage = (String)data.get("faultMessage");
                if (faultMessage != null) {
                    FaultFeature.constructAndSendFaultSnapshotToServer((InvocationData)data, (String)faultMessage, (IAgent)this.getAgent());
                    FaultFeature.decorateTransactionsWithFault((InvocationData)data, (String)faultMessage);
                }
                if ((prevFault = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)(faultMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(String.valueOf(data.getComponentNameAt(tracerIndex)) + ":" + "SOAP Faults Per Interval", 8194, "Invalid Names:Invalid name given for a long interval counter metric")), (IRepository)(newFault = BlamePointTracer.getCountQueuedRepository((boolean)true)))) != null) {
                    this.fFaultRep.set(prevFault);
                } else {
                    this.fFaultRep.set(newFault);
                }
                this.fFaultRep.get().update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
            }
            catch (Exception e) {
                WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", e);
                WMUtils.getLogger().debug("Error in Fault Tracer:" + e.getMessage());
            }
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

