/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.webservices.tracer.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.soaextension.webmethods.webservices.tracer.hc2.WebServicesClientFaultTracer;
import com.wily.util.StringUtils;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Method;

public class WebServices80ClientFaultTracer
extends WebServicesClientFaultTracer {
    public WebServices80ClientFaultTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected String getComponentName(InvocationData data) {
        String wsname = "";
        String operation = "";
        try {
            Object idataObj = data.getInvocationParameterAsObject(0);
            Object[] objArr = new Object[]{idataObj, "wsdOperationName"};
            operation = WMUtils.invokeGetStringOnValuesEmulator(objArr);
            String wsdName = WMUtils.getWsdNameForVersion8x();
            Object[] objArrCreate = new Object[]{wsdName};
            Object nsObj = WMUtils.invokeCreateOnName(objArrCreate);
            Object[] nsObjArr = new Object[]{nsObj};
            Object wsdObj = WMUtils.invokeGetWSDescOnNamespace(nsObjArr);
            if (wsdObj != null) {
                Method getTargetNS = WMUtils.getTargetNSonWSD(wsdObj);
                wsname = (String)getTargetNS.invoke(wsdObj, new Object[0]);
            }
            WMUtils.getLogger().debug("WSClientFaultTracer Client::WebService Namespace:" + wsname);
            WMUtils.getLogger().debug("WSClientFaultTracer Client::WebService Operation:" + operation);
        }
        catch (Exception e) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", e);
            WMUtils.getLogger().debug("Error in Fault Tracer:" + e.getMessage());
        }
        wsname = WMUtils.formatToBeResourceSafe(wsname);
        if (wsname == null || wsname.equals("")) {
            wsname = "UnknownService";
        }
        if ((operation = WMUtils.formatToBeResourceSafe(operation)) == null || operation.equals("")) {
            operation = "UnknownOperation";
        }
        data.put("ServiceName", (Object)wsname);
        data.put("Operation", (Object)operation);
        WMUtils.getLogger().debug("WSClientFaultTracer::Got ServiceName as:" + wsname + " & Operation as:" + operation);
        String component = this.getParameter("name");
        if (component.indexOf("{namespace}", 0) >= 0) {
            component = StringUtils.replace((String)component, (String)"{namespace}", (String)wsname);
        }
        if (component.indexOf("{operationname}", 0) >= 0) {
            component = StringUtils.replace((String)component, (String)"{operationname}", (String)operation);
        }
        data.put("ComponentName", (Object)component);
        return component;
    }
}

