/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.jmx;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.AJMXDataView;
import com.wily.introscope.agent.jmx.CompositeDataJMXDataView;
import com.wily.introscope.agent.jmx.IntJMXDataView;
import com.wily.introscope.agent.jmx.JMXDelegatingService;
import com.wily.introscope.agent.jmx.LongJMXDataView;
import com.wily.introscope.agent.jmx.RateCounterJMXDataView;
import com.wily.introscope.agent.jmx.StringJMXDataView;
import com.wily.introscope.agent.stat.AccumulatorAlreadyExistsException;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class DataViewFactory {
    static final int kIntViewType = 1;
    static final int kLongViewType = 2;
    static final int kStringViewType = 3;
    static final int kConpositeDataViewType = 4;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    public static AJMXDataView createView(IAgent agent, ObjectName mbeanName, String jmxAttributeType, String jmxAttributeName, MBeanServer server, String fullIntroscopeMetricName, boolean excludeStringMetrics, boolean includeRateCounterMetrics) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        int viewType = DataViewFactory.getViewType(jmxAttributeType);
        if (includeRateCounterMetrics) {
            if (viewType == 1 || viewType == 2) {
                return new RateCounterJMXDataView(agent, mbeanName, server, jmxAttributeName, fullIntroscopeMetricName);
            }
            return null;
        }
        switch (viewType) {
            case 1: {
                return new IntJMXDataView(agent, mbeanName, server, jmxAttributeName, fullIntroscopeMetricName);
            }
            case 2: {
                return new LongJMXDataView(agent, mbeanName, server, jmxAttributeName, fullIntroscopeMetricName);
            }
            case 4: {
                if (JMXDelegatingService.sIsJMXCompositeDataEnabled) {
                    return new CompositeDataJMXDataView(agent, mbeanName, server, jmxAttributeName, fullIntroscopeMetricName);
                }
                return null;
            }
            case 3: {
                if (!excludeStringMetrics) {
                    return new StringJMXDataView(agent, mbeanName, server, jmxAttributeName, fullIntroscopeMetricName);
                }
                return null;
            }
        }
        return null;
    }

    public static int getViewType(String inputType) {
        String type = inputType.replace('/', '.');
        if (DataViewFactory.isLongType(type)) {
            return 2;
        }
        if (DataViewFactory.isIntType(type)) {
            return 1;
        }
        if (DataViewFactory.isCompositeType(type)) {
            return 4;
        }
        return 3;
    }

    private static boolean isLongType(String type) {
        block20: {
            block19: {
                if (type.equals(Long.TYPE.getName())) break block19;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type.equals(clazz.getName()) || type.equals(Double.TYPE.getName())) break block19;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type.equals(clazz2.getName()) || type.equals(Float.TYPE.getName())) break block19;
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type.equals(clazz3.getName())) break block19;
                Class<?> clazz4 = class$3;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$3 = Class.forName("java.lang.Number");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!type.equals(clazz4.getName())) break block20;
            }
            return true;
        }
        return false;
    }

    private static boolean isIntType(String type) {
        block16: {
            block15: {
                if (type.equals(Short.TYPE.getName())) break block15;
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type.equals(clazz.getName()) || type.equals(Integer.TYPE.getName())) break block15;
                Class<?> clazz2 = class$5;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$5 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type.equals(clazz2.getName()) || type.equals(Byte.TYPE.getName())) break block15;
                Class<?> clazz3 = class$6;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$6 = Class.forName("java.lang.Byte");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!type.equals(clazz3.getName())) break block16;
            }
            return true;
        }
        return false;
    }

    private static boolean isCompositeType(String type) {
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("javax.management.openmbean.CompositeData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return type.equals(clazz.getName());
    }
}

