/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.jmx;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.AJMXDataView;
import com.wily.introscope.agent.jmx.DataViewFactory;
import com.wily.introscope.agent.jmx.MBeanInterpreter;
import com.wily.introscope.agent.stat.AccumulatorAlreadyExistsException;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

final class MBeanInterpreterJMXDataView
extends AJMXDataView {
    private AJMXDataView[] values;
    private String introscopeMetricNameRoot;
    private MBeanInterpreter interpreter;
    private boolean fExcludeStringMetrics;
    private boolean fIncludeRateCounterMetrics;
    private static final String kExcludeStringMetricsPropKey = "introscope.agent.jmx.excludeStringMetrics";

    public MBeanInterpreterJMXDataView(IAgent agent, ObjectName objectName, MBeanServer server, String attributeName, String introscopeMetricNameRoot, MBeanInterpreter interpreter, boolean includeRateCounterMetrics) {
        super(agent, objectName, server, attributeName);
        this.introscopeMetricNameRoot = introscopeMetricNameRoot;
        this.interpreter = interpreter;
        this.fExcludeStringMetrics = agent.IAgent_getIndexedProperties().getBooleanProperty(kExcludeStringMetricsPropKey, true);
        this.fIncludeRateCounterMetrics = includeRateCounterMetrics;
    }

    protected void doUpdate(Object currentValue) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        int valueII;
        boolean firstTime = this.values == null;
        MBeanInterpreter.MetricGroupDefinition[] rawValues = this.interpreter.retrieveValues(currentValue, firstTime);
        int totalMetricCount = 0;
        if (rawValues != null) {
            int II = 0;
            while (II < rawValues.length) {
                totalMetricCount += rawValues[II].values.length;
                ++II;
            }
        }
        if (firstTime && rawValues != null) {
            this.values = new AJMXDataView[totalMetricCount];
            valueII = -1;
            int valueGroupII = 0;
            while (valueGroupII < rawValues.length) {
                MBeanInterpreter.MetricGroupDefinition group = rawValues[valueGroupII];
                String groupMetricName = this.introscopeMetricNameRoot;
                int parentNameII = 0;
                while (parentNameII < group.metricPath.length) {
                    if (group.metricPath[parentNameII] != null) {
                        groupMetricName = String.valueOf(groupMetricName) + "|" + group.metricPath[parentNameII];
                    }
                    ++parentNameII;
                }
                int leafII = 0;
                while (leafII < group.values.length) {
                    ++valueII;
                    String finalMetricName = String.valueOf(groupMetricName) + ":" + group.keys[leafII];
                    try {
                        AJMXDataView view = DataViewFactory.createView(this.getAgent(), this.getSourceObjectName(), group.values[leafII].getClass().getName(), group.keys[leafII], this.getSourceServer(), finalMetricName, this.fExcludeStringMetrics, this.fIncludeRateCounterMetrics);
                        this.getAgent().IAgent_getModuleFeedback().debug("Creating view with Final Metric Name ->" + finalMetricName);
                        this.values[valueII] = view;
                        this.getAgent().IAgent_getModuleFeedback().debug("Created view with Final Metric Name ->" + finalMetricName);
                    }
                    catch (BadlyFormedNameException except) {
                        this.getAgent().IAgent_getModuleFeedback().debug("Error registering view", except);
                        break;
                    }
                    catch (ConflictingTypesException except) {
                        this.getAgent().IAgent_getModuleFeedback().debug("Error registering view", except);
                        break;
                    }
                    catch (AccumulatorAlreadyExistsException except) {
                        this.getAgent().IAgent_getModuleFeedback().debug("Error registering view", except);
                        break;
                    }
                    ++leafII;
                }
                ++valueGroupII;
            }
        }
        if (this.values != null) {
            valueII = -1;
            int groupII = 0;
            while (groupII < rawValues.length) {
                int leafII = 0;
                while (leafII < rawValues[groupII].values.length) {
                    if (this.values[++valueII] != null) {
                        this.values[valueII].doUpdate(rawValues[groupII].values[leafII]);
                    }
                    ++leafII;
                }
                ++groupII;
            }
        }
    }

    protected IDataAccumulator getAccumulator() {
        return null;
    }

    protected IDataAccumulator getAccumulator(boolean forceCreate) {
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doDestroy() {
        if (this.values == null) return;
        try {
            int valueII = 0;
            while (valueII < this.values.length) {
                this.values[valueII].doDestroy();
                ++valueII;
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.values = null;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.values = null;
            return;
        }
    }

    protected boolean isVirtual() {
        return true;
    }

    public String getFullMetricName() {
        return "Group " + this.introscopeMetricNameRoot;
    }
}

