/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.jmx;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.AJMXDataView;
import com.wily.introscope.agent.stat.AccumulatorAlreadyExistsException;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IStringEveryEventDataAccumulator;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class StringJMXDataView
extends AJMXDataView {
    private IStringEveryEventDataAccumulator fAccumulator;
    private String fFullIntroscopeMetricName;
    private String fLastValue = null;
    private String fCurrentValue = null;
    private boolean fWasSame = false;

    public StringJMXDataView(IAgent agent, ObjectName on, MBeanServer server, String attributeName, String fullIntroscopeMetricName) {
        super(agent, on, server, attributeName);
        this.fFullIntroscopeMetricName = fullIntroscopeMetricName;
    }

    protected void doUpdate(Object currentValue) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        StringBuffer buf = new StringBuffer();
        if (currentValue instanceof Object[]) {
            Object[] array = (Object[])currentValue;
            buf.append('{');
            if (array.length != 0) {
                buf.append(array[0].toString());
            }
            int i = 1;
            while (i < array.length) {
                buf.append(", ");
                buf.append(array[i].toString());
                if (buf.length() > 21845) break;
                ++i;
            }
            buf.append('}');
        } else {
            buf.append(currentValue.toString());
        }
        IStringEveryEventDataAccumulator accumulator = this.getTypedAccumulator();
        if (accumulator != null) {
            this.fLastValue = this.fCurrentValue;
            this.fCurrentValue = buf.toString();
            if (this.fCurrentValue != null && this.fLastValue != null) {
                boolean bl = this.fWasSame = this.fCurrentValue.compareTo(this.fLastValue) == 0;
            }
            if (this.fWasSame) {
                this.setSawSameValue();
            } else {
                this.resetSawSameValue();
            }
            accumulator.IStringEveryEventDataAccumulator_addString(buf.toString());
        }
    }

    public String debug_GetCurrentAndLastValues() {
        return null;
    }

    protected IDataAccumulator getAccumulator(boolean forceCreate) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        if (forceCreate && this.fAccumulator == null) {
            this.fAccumulator = this.getAgent().IAgent_getDataAccumulatorFactory().createStringEveryEventDataAccumulator(this.fFullIntroscopeMetricName);
        }
        return this.fAccumulator;
    }

    private IStringEveryEventDataAccumulator getTypedAccumulator() throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return (IStringEveryEventDataAccumulator)this.getAccumulator(true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doDestroy() {
        try {
            if (this.fAccumulator != null) {
                this.getAgent().IAgent_getDataAccumulatorFactory().removeDataAccumulator((IDataAccumulator)this.fAccumulator);
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.fAccumulator = null;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.fAccumulator = null;
            return;
        }
    }

    public String getFullMetricName() {
        return this.fFullIntroscopeMetricName;
    }
}

