/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.wldf;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.wldf.IWLDFDataView;
import com.wily.introscope.agent.wldf.WLDFDataUnavailableException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public abstract class AWLDFDataView
implements IWLDFDataView {
    private String fSourceAttribute;
    private ObjectName fSourceObjectName;
    private MBeanServer fServer;
    private IAgent fAgent;
    static final int kMaxAllowableExceptionCount = 2;

    protected AWLDFDataView(IAgent agent, ObjectName on, MBeanServer server, String attributeName) {
        this.fAgent = agent;
        this.fSourceAttribute = attributeName;
        this.fServer = server;
        this.fSourceObjectName = on;
    }

    protected ObjectName getSourceObjectName() {
        return this.fSourceObjectName;
    }

    protected MBeanServer getSourceServer() {
        return this.fServer;
    }

    protected String getSourceAttribute() {
        return this.fSourceAttribute;
    }

    protected IAgent getAgent() {
        return this.fAgent;
    }

    public final void IWLDFDataView_destroy() {
        this.fSourceAttribute = null;
        this.fServer = null;
        this.fSourceObjectName = null;
        this.doDestroy();
    }

    public boolean IWLDFDataView_update(Object objectValue) throws WLDFDataUnavailableException {
        boolean debugEnabled = this.getAgent().IAgent_getModuleFeedback().isDebugEnabled();
        if (this.fAgent.IAgent_isMetricShutOff(this.getAccumulator().IDataAccumulator_getMetric())) {
            return true;
        }
        if (debugEnabled) {
            this.getAgent().IAgent_getModuleFeedback().debug("AWLDFDataView: updating data view for MBeanServer -->" + this.getSourceServer() + "<-- and ON -->" + this.getSourceObjectName() + "<-- and Attr -->" + this.getSourceAttribute() + "<-- with value -->" + objectValue + "<--");
        }
        if (objectValue != null) {
            this.doUpdate(objectValue);
        }
        return objectValue != null;
    }

    protected abstract void doDestroy();

    protected abstract IDataAccumulator getAccumulator();

    protected abstract void doUpdate(Object var1);

    public String getFSourceAttribute() {
        return this.fSourceAttribute;
    }
}

