/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.wldf;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.AccumulatorAlreadyExistsException;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.ILongFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.wldf.AWLDFDataView;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class LongWLDFDataView
extends AWLDFDataView {
    private ILongFluctuatingCounterDataAccumulator fAccumulator;
    private String fullMetricName;

    public LongWLDFDataView(IAgent agent, ObjectName on, MBeanServer server, String attributeName, String fullIntroscopeMetricName) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        super(agent, on, server, attributeName);
        this.fAccumulator = this.getAgent().IAgent_getDataAccumulatorFactory().createLongFluctuatingCounterDataAccumulator(fullIntroscopeMetricName);
        this.fullMetricName = fullIntroscopeMetricName;
    }

    protected void doUpdate(Object currentValue) {
        boolean shouldUpdate = false;
        long longValue = 0L;
        if (currentValue instanceof Number) {
            Number numberValue = (Number)currentValue;
            longValue = numberValue.longValue();
            shouldUpdate = true;
        } else if (currentValue instanceof String) {
            try {
                longValue = Long.parseLong((String)currentValue);
                shouldUpdate = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (shouldUpdate) {
            this.fAccumulator.ILongCounterDataAccumulator_setValue(longValue);
        }
    }

    protected IDataAccumulator getAccumulator() {
        return this.fAccumulator;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doDestroy() {
        try {
            if (this.fAccumulator != null) {
                this.getAgent().IAgent_getDataAccumulatorFactory().removeDataAccumulator((IDataAccumulator)this.fAccumulator);
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.fAccumulator = null;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.fAccumulator = null;
            return;
        }
    }

    public String getFullMetricName() {
        return this.fullMetricName;
    }
}

