/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.locale;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;

public class LocaleUtils {
    private static final Locale BASE_FALLBACK_LOCALE = Locale.ENGLISH;

    public static Locale stringToLocale(String localeStr) {
        String[] tokens = localeStr.split("-");
        if (tokens.length < 1) {
            return null;
        }
        String iso3Lang = tokens[0];
        String iso3Country = "";
        if (tokens.length > 1) {
            iso3Country = tokens[1];
        }
        return new Locale(iso3Lang, iso3Country);
    }

    public static String localeToString(Locale locale) {
        String localeStr = locale.getLanguage();
        if (locale.getCountry().length() > 0) {
            localeStr = String.valueOf(localeStr) + "-" + locale.getCountry();
        }
        return localeStr;
    }

    public static String bestAvailableLocale(Set localeStrings, Locale reqLocale) {
        if (reqLocale == null) {
            return null;
        }
        String localeStr = LocaleUtils.localeToString(reqLocale);
        if (localeStrings.contains(localeStr)) {
            return localeStr;
        }
        localeStr = reqLocale.getLanguage();
        if (localeStrings.contains(localeStr)) {
            return localeStr;
        }
        if (LocaleUtils.isBaseLocale(localeStr)) {
            return null;
        }
        Locale defaultLocale = Locale.getDefault();
        localeStr = LocaleUtils.localeToString(defaultLocale);
        if (localeStrings.contains(localeStr)) {
            return localeStr;
        }
        localeStr = defaultLocale.getLanguage();
        if (localeStrings.contains(localeStr)) {
            return localeStr;
        }
        return null;
    }

    public static boolean haveLocalizedResource(Locale locale, String resource, ClassLoader loader) {
        if (locale == null || loader == null) {
            return false;
        }
        ResourceBundle bundle = ResourceBundle.getBundle(resource, locale, loader);
        if (bundle == null) {
            return false;
        }
        return bundle.getLocale().getLanguage().equals(locale.getLanguage());
    }

    public static boolean isBaseLocale(String locale) {
        return locale.equalsIgnoreCase(BASE_FALLBACK_LOCALE.getLanguage());
    }

    public static Locale getFallbackLocale() {
        return BASE_FALLBACK_LOCALE;
    }
}

