/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.xml.converter;

import com.wily.util.xml.XMLAssistant;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public class XMLConverter {
    private DocumentType fNewDocumentTypeTemplate;
    private final double fVersionNumber;
    private Templates[] fTemplates;
    private ErrorListener fErrorListener;
    private Map fParameters;

    public XMLConverter(double versionNumber, InputStream[] xsltInputStreams, DocumentType newDocumentTypeTemplate, ErrorListener errorListener) throws TransformerConfigurationException {
        this.fVersionNumber = versionNumber;
        this.fTemplates = this.getTemplates(xsltInputStreams);
        this.fNewDocumentTypeTemplate = newDocumentTypeTemplate;
        this.fErrorListener = errorListener;
    }

    public XMLConverter(double versionNumber, InputStream[] xsltInputStreams, DocumentType newDocumentTypeTemplate) throws TransformerConfigurationException {
        this.fVersionNumber = versionNumber;
        this.fTemplates = this.getTemplates(xsltInputStreams);
        this.fNewDocumentTypeTemplate = newDocumentTypeTemplate;
        this.fErrorListener = null;
    }

    protected XMLConverter(double versionNumber) {
        this.fVersionNumber = versionNumber;
        this.fNewDocumentTypeTemplate = null;
        this.fErrorListener = null;
    }

    protected void finishInitialization(InputStream[] xsltInputStreams, DocumentType newDocumentTypeTemplate) throws TransformerConfigurationException {
        this.fTemplates = this.getTemplates(xsltInputStreams);
        this.fNewDocumentTypeTemplate = newDocumentTypeTemplate;
    }

    public double getVersionNumber() {
        return this.fVersionNumber;
    }

    public Document convert(Document document) throws IOException, TransformerException, ParserConfigurationException {
        Document[] documents = new Document[]{document};
        Document[] results = this.convert(documents);
        return results[0];
    }

    public Document[] convert(Document[] documents) throws IOException, TransformerException, ParserConfigurationException {
        Document[] convertedDocuments = new Document[]{};
        if (this.fTemplates.length == 0) {
            convertedDocuments = documents;
        } else if (documents.length > 0) {
            Document superDocument;
            Document currentDocument = superDocument = XMLAssistant.createSuperDocument(documents);
            DOMResult currentResult = null;
            int i = 0;
            while (i < this.fTemplates.length) {
                Map parameters;
                Transformer transformer = this.fTemplates[i].newTransformer();
                DOMSource currentDocumentDOMSource = new DOMSource(currentDocument);
                currentResult = new DOMResult();
                ErrorListener errorListener = this.getErrorListener();
                if (errorListener != null) {
                    transformer.setErrorListener(errorListener);
                }
                if ((parameters = this.getParameters()) != null) {
                    Iterator pi = parameters.entrySet().iterator();
                    while (pi.hasNext()) {
                        Map.Entry param = pi.next();
                        String paramName = (String)param.getKey();
                        Object paramValue = param.getValue();
                        if (paramName == null || paramValue == null) continue;
                        transformer.setParameter(paramName, paramValue);
                    }
                    transformer.setErrorListener(errorListener);
                }
                transformer.transform(currentDocumentDOMSource, currentResult);
                currentDocument = (Document)currentResult.getNode();
                ++i;
            }
            convertedDocuments = XMLAssistant.createSubDocuments(currentDocument, this.fNewDocumentTypeTemplate);
        }
        return convertedDocuments;
    }

    protected Templates[] getTemplates(InputStream[] iStreams) throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        ArrayList<Templates> transformers = new ArrayList<Templates>();
        int i = 0;
        while (i < iStreams.length) {
            StreamSource xsltSource = new StreamSource(iStreams[i]);
            Templates transformer = transformerFactory.newTemplates(xsltSource);
            transformers.add(transformer);
            ++i;
        }
        return transformers.toArray(new Templates[0]);
    }

    public ErrorListener getErrorListener() {
        return this.fErrorListener;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.fErrorListener = errorListener;
    }

    public Map getParameters() {
        return this.fParameters;
    }

    public void setParameters(Map parameters) {
        this.fParameters = parameters;
    }
}

